/* $Id$ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1998.
 *========================================================================
 *              FILE NAME: arrowheads.h
 *            DESCRIPTION: arrow head definitions for ArrowGFX plug-in
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *       PUBLIC FUNCTIONS: 
 *      PRIVATE FUNCTIONS: 
 *  SOFTWARE DEPENDENCIES: 
 *  HARDWARE DEPENDENCIES: 
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/
#ifndef ARROWHEAD_H
#define ARROWHEAD_H

/*
 * Generic definitions for ArrowFileHdr structures.
 */
#define GFX_ARROW_MAGIC		(('G' << 24) + ('F' << 16) + ('X' << 8 ) + ('A'))
#define GFX_ARROW_VERSION		1
#define GFX_ARROW_GRID_SIZE	31
#define GFX_ARROW_LINE_SOLID	1
#define GFX_ARROW_LINE_DOTTED	2
#define GFX_ARROW_LINE_DBL		3
#define GFX_ARROW_FILLED		1
#define GFX_ARROW_NOTFILLED	2

#define SIDE_MARGINS		6
#define TOP_MARGINS		6

#define ARROW_VERTEX_MAX		7
#define ARROW_MAX_COLUMNS		4
#define ARROW_BOX_WIDTH			2		/* number of pixels to pad on one side */
#define ARROW_BOX_HEIGHT		2		/* number of pixels to pad on one side */

/*========================================================================
 * ARROW Definitions
 *========================================================================*/
#define ARROW_DEFS		8

#ifdef ARROWHEADS_C
ArrowFileHdr arrow_hdrs[ARROW_DEFS] =  {

	/* Normal Triangle */
	{ GFX_ARROW_MAGIC,
	  GFX_ARROW_VERSION,
	  GFX_ARROW_GRID_SIZE,
	  GFX_ARROW_LINE_SOLID,
	  GFX_ARROW_FILLED,
	  0, 0, 0,
	  {12,31, 20,31, 10},
	  3 
	},

	/* Inverted Normal Triangle */
	{ GFX_ARROW_MAGIC,
	  GFX_ARROW_VERSION,
	  GFX_ARROW_GRID_SIZE,
	  GFX_ARROW_LINE_SOLID,
	  GFX_ARROW_FILLED,
	  0, 0, 0,
	  {13,20, 17,20, 10},
	  3 
	},

	/* Left Half Wedge */
	{ GFX_ARROW_MAGIC,
	  GFX_ARROW_VERSION,
	  GFX_ARROW_GRID_SIZE,
	  GFX_ARROW_LINE_SOLID,
	  GFX_ARROW_FILLED,
	  0, 0, 0,
	  {13,31, 16,31, 10},
	  3 
	},

	/* Right Half Wedge */
	{ GFX_ARROW_MAGIC,
	  GFX_ARROW_VERSION,
	  GFX_ARROW_GRID_SIZE,
	  GFX_ARROW_LINE_SOLID,
	  GFX_ARROW_FILLED,
	  0, 0, 0,
	  {16,31, 19,31, 10},
	  3 
	},

	/* Diamond */
	{ GFX_ARROW_MAGIC,
	  GFX_ARROW_VERSION,
	  GFX_ARROW_GRID_SIZE,
	  GFX_ARROW_LINE_SOLID,
	  GFX_ARROW_FILLED,
	  0, 0, 0,
	  {14,16, 18,16, 26},
	  4 
	},

	/* Inverted "V" */
	{ GFX_ARROW_MAGIC,
	  GFX_ARROW_VERSION,
	  GFX_ARROW_GRID_SIZE,
	  GFX_ARROW_LINE_SOLID,
	  GFX_ARROW_FILLED,
	  0, 0, 0,
	  {14,13, 18,13, 28},
	  4 
	},

	/* Inverted "V" with tail */
	{ GFX_ARROW_MAGIC,
	  GFX_ARROW_VERSION,
	  GFX_ARROW_GRID_SIZE,
	  GFX_ARROW_LINE_SOLID,
	  GFX_ARROW_FILLED,
	  0, 0, 0,
	  {12,31, 20,31, 0},
	  7 
	},

	/* Crown */
	{ GFX_ARROW_MAGIC,
	  GFX_ARROW_VERSION,
	  GFX_ARROW_GRID_SIZE,
	  GFX_ARROW_LINE_SOLID,
	  GFX_ARROW_FILLED,
	  0, 0, 0,
	  {8,31, 22,31, 0},
	  7 
	},

};

ArrowFileVertex arrow_vertices[ARROW_DEFS][ARROW_VERTEX_MAX] = {

	/* Normal Triangle */
	{	{16, 0, 0,0,0, 1}, 
		{ 0,31, 0,0,0, 1}, 
		{31,31, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1}
	},

	/* Inverted Normal Triangle */
	{	{ 0, 0, 0,0,0, 1}, 
		{15,31, 0,0,0, 1}, 
		{31, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1}
	},

	/* Left Half Wedge */
	{	{16, 0, 0,0,0, 1}, 
		{16,31, 0,0,0, 1}, 
		{ 0,31, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1}
	},

	/* Right Half Wedge */
	{	{16, 0, 0,0,0, 1}, 
		{16,31, 0,0,0, 1}, 
		{31,31, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1}
	},

	/* Diamond */
	{	{16, 0, 0,0,0, 1}, 
		{ 0,16, 0,0,0, 1}, 
		{16,31, 0,0,0, 1},
		{31,16, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1}
	},

	/* Inverted "V" */
	{	{16, 0, 0,0,0, 1}, 
		{ 0,31, 0,0,0, 1}, 
		{16,16, 0,0,0, 1}, 
		{31,31, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1},
		{ 0, 0, 0,0,0, 1}
	},

	/* Inverted "V" with tail */
	{	{16, 0, 0,0,0, 1}, 
		{ 0,31, 0,0,0, 1}, 
		{12,22, 0,0,0, 1}, 
		{12,31, 0,0,0, 1}, 
		{20,31, 0,0,0, 1}, 
		{20,22, 0,0,0, 1}, 
		{31,31, 0,0,0, 1},
	},

	/* Crown */
	{	{ 0, 0, 0,0,0, 1}, 
		{ 8,31, 0,0,0, 1}, 
		{22,31, 0,0,0, 1}, 
		{31, 0, 0,0,0, 1}, 
		{20,15, 0,0,0, 1}, 
		{15, 0, 0,0,0, 1}, 
		{10,15, 0,0,0, 1},
	},
};
#else
extern ArrowFileHdr arrow_hdrs[ARROW_DEFS];
extern ArrowFileVertex arrow_vertices[ARROW_DEFS][ARROW_VERTEX_MAX];
#endif /* MAIN_C */


#endif /* ARROWHEAD_H */
