/* $Id$ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1998.
 *========================================================================
 *              FILE NAME: arrows.h
 *            DESCRIPTION: main header file for ArrowGFX plug-in
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *       PUBLIC FUNCTIONS: 
 *      PRIVATE FUNCTIONS: 
 *  SOFTWARE DEPENDENCIES: 
 *  HARDWARE DEPENDENCIES: 
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/
#ifndef ARROWGFX_H
#define ARROWGFX_H

/*
 * Information used by gimp_install_procedure() in the ArrowGFXQuery() 
 * routine.
 */
#define ARROWGFX_NAME			"plugin-arrowgfx"
#define ARROWGFX_BLURB			"Create arrow pointers of varying shapes and sizes"
#define ARROWGFX_HELP			ARROWGFX_BLURB
#define ARROWGFX_AUTHOR			"Michael J. Hammel <mjhammel@graphics-muse.org>"
#define ARROWGFX_COPYRIGHT		"Private License - Copyright 1998 Michael J. Hammel"
#define ARROWGFX_DATE			"1998/10/05"
#define ARROWGFX_MENU_PATH		"<Image>/Filters/GFXMuse/ArrowGFX"
#define ARROWGFX_IMAGE_TYPES	"RGB*,GRAY*,INDEXED*"
#define ARROWGFX_PROC_TYPE		GIMP_PLUGIN

/*
 * The name to use for saving configuration data
 */
#define ARROWGFX_PI_NAME		"ArrowGFX"

/*
 * Title and Version information for our dialogs.
 */
#define ARROWGFX_TITLE			"ArrowGFX "
#define ARROWGFX_VERSION		"0.1"

/*
 * Size of the preview window.  This one we keep square.
 * The preview arrows has to fit in the square as it is rotated around the
 * center of the sqare.
 */
#define PREVIEW_HSIZE					174
#define PREVIEW_WSIZE					174
#define PREVIEW_PG_HSIZE				120	
#define PREVIEW_PG_WSIZE				120
#define ARROW_PREVIEW_WSIZE			185
#define ARROW_PREVIEW_HSIZE			30
#define ARROW_PREVIEW_BUTTON_WSIZE	31
#define ARROW_PREVIEW_BUTTON_HSIZE	31

/*
 * Various defaults.
 */
#define OPACITY_DEFAULT				100.0
#define DPI_DEFAULT					72
#define DPI_MAX_DEFAULT				1490
#define SCALING_DEFAULT				1.0
#define SCALING_MAX_DEFAULT		9.0
#define AIRBRUSH_DEFAULT			10
#define PAINTBRUSH_DEFAULT			0
#define OFFSET_X_DEFAULT			0
#define OFFSET_Y_DEFAULT			0
#define MARGIN_X_DEFAULT			10
#define MARGIN_Y_DEFAULT			10
#define MARGIN_MAX_DEFAULT			50.0

/*
 * Generic types.
 */
#define ARROWGFX_TYPE_NEW_LAYER	1
#define ARROWGFX_TYPE_ANCHOR		2
#define ARROWGFX_TYPE_MASK			3
#define ARROWGFX_TYPE_CHANNEL		4
#define ARROWGFX_TYPE_PENCIL		5
#define ARROWGFX_TYPE_PAINTBRUSH	6
#define ARROWGFX_TYPE_AIRBRUSH	7
#define ARROWGFX_TYPE_STROKE		8
#define ARROWGFX_TYPE_FILL			9
#define ARROWGFX_TYPE_PATTERN_OL	10
#define ARROWGFX_TYPE_PATTERN		11
#define ARROWGFX_TYPE_OUTLINE		12
#define ARROWGFX_TYPE_OFFSET_X	13
#define ARROWGFX_TYPE_OFFSET_Y	14
#define ARROWGFX_TYPE_DRAW			15
#define ARROWGFX_TYPE_DONT_DRAW	16

#define ARROWGFX_DOWN				1
#define ARROWGFX_UP					2

#define ARROWGFX_INCHES				0
#define ARROWGFX_PIXELS				1

/*
 * Identifiers for text field updates routine.
 */
#define ARROWGFX_ANGLE_TEXT_FIELD	1


/*========================================================================
 * Data structures
 *========================================================================*/

/*
 * Vertices in the Arrow File.
 */
typedef struct _arrow_file_vertex {
	int	x;			/* x coordinate */
	int	y;			/* y coordinate */
	int	red;		/* Red component */
	int	green;	/* Green component */
	int	blue;		/* Blue component */
	int	connect;	/* connect to next vertex: 1=yes, 0=no */
} ArrowFileVertex;

/*
 * Tail definition.  The tail is defined by specifying two starting points
 * and a length.  The tail extends from these points down the specified
 * length from each point.
 */
typedef struct _arrow_file_tail {
	int	x1;		/* top coordinate 1 */
	int	y1;		/* top coordinate 1 */
	int	x2;		/* top coordinate 2 */
	int	y2;		/* top coordinate 2 */
	int	length;	/* tail length */
} ArrowFileTail;

/*
 * The Arrow File Format header block.
 */
typedef struct _arrow_file_hdr {
	int				magic;		/* magic number identifying arrow files */
	char				version;		/* version number for given file */
	char				grid_size;	/* number of pixels in both x & y directions */
	char  			line_style;	/* line style for vertex connections */
	char  			filled;		/* 0: polygon not filled, 1: poly is filled */
	char  			red;			/* color of fill, if filled is 1 */
	char  			green;		/* color of fill, if filled is 1 */
	char  			blue;			/* color of fill, if filled is 1 */
	ArrowFileTail	tail;			/* tail definition */
	char  			points;		/* number of vertices in polygon */
} ArrowFileHdr;


/*
 * Help Text.
 */
#include "help.h"

#endif /* ARROWGFX_H */
