/* $Id$ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1998.
 *========================================================================
 *              FILE NAME: help.h
 *            DESCRIPTION: help text for gfxarrow
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *       PUBLIC FUNCTIONS: 
 *      PRIVATE FUNCTIONS: 
 *  SOFTWARE DEPENDENCIES: 
 *  HARDWARE DEPENDENCIES: 
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/
#ifndef HELP_H
#define HELP_H

/*========================================================================
 * Help Text for ArrowGFX.
 *========================================================================*/
#define GFX_HELP_TEXT	\
"\n \
\n \
                                                   The Graphics Muse Tools\n \
                                                          \"ArrowGFX\"\n \
\n \
\n \
\n \
\n \
ArrowGFX Online Help\n \
\n \
Welcome to ArrowGFX Online from the Graphics Muse!  ArrowGFX is a\n \
GIMP Plug-In for creating all sorts of pointers, oriented in any direction\n \
and with variable length tails, as new layers, masks, or even over the the\n \
original layer!\n \
\n \
On this page you'll find everything you need to know in order to get started\n \
with and make the most use of ArrowGFX.  Once you've gotten the hang of this\n \
plug-in, be sure to check out the other GFXMuse Tools plug-ins:\n \
\n \
   * CardGFX\n \
   * TransGFX\n \
\n \
Table of Contents\n \
\n \
   * The Main Dialog\n \
   * Image/Layer Options\n \
   * Drawing Options\n \
   * Drawing the selected arrow\n \
   * Resetting and Closing the main dialog\n \
   * Samples\n \
\n \
A tour of the ArrowGFX main dialog window\n \
\n \
The ArrowGFX main dialog consists of a notebook with 3 pages:  Arrow Options, \n \
Image/Layer Options, and Draw Options.  The opening page, Arrow Options, is \n \
used to select an arrow head type, tail length, and overall scaling.  In the \n \
upper left is the Rotation Angle Preview.  When an arrow head has been \n \
selected, a preview of the arrow will be drawn within the circular outline of \n \
the Preview.  Clicking and dragging within the Preview will rotate the arrow \n \
around the edge of the circular outline.  Changes to the orientation of the \n \
arrow in the Preview will cause the Angle input field (just to the right of the\n \
Preview) to be updated automatically.  Additionally you can type in specific\n \
degrees of rotation in that field.  Note that the maximum rotation value is\n \
359 degrees while the minimum is -359 degrees.\n \
\n \
Selecting an arrow head is simple enough - just click on one of the icons in\n \
the Arrow Heads window just beneath the Preview window.  When you click on\n \
an arrow head it will be outlined to show it has been selected and the\n \
preview will be updated with the new shape.  Also, the Tail Length slider\n \
and input field will be reset to the defaults for the newly selected tail.\n \
\n \
Changes to the Tail Length slider will update the Preview window, causing\n \
the tail to be extended from the arrow head.  The tail length can be quite\n \
long in relation to the size of the arrow head and can extend past the\n \
circular outline of the Preview window.  However, the tail display is\n \
limited to the inside of the raised frame of the Preview window.\n \
\n \
Below the Tail Length slider you will find an option for scaling the arrow.\n \
By default the scaling is set to 1.0, meaning that the bounding box for the\n \
arrow, when drawn, will be the size specified by the Size box. Below the\n \
Scaling option is the DPI option.  Setting the DPI to something other than\n \
72 is probably only necessary for those needing to work in terms of printed\n \
output dimensions and resolutions or if you can't create a bounding box\n \
large enough simply by increasing the scaling amount.  The Size box, below\n \
the DPI option, shows the dimensions of the bounding box for the drawn arrow\n \
and tail.  The default here is to display the size in inches, but this can\n \
be changed to pixels using the size options menu.\n \
\n \
The computed size of the bounding box is dependent on 3 things:  the scaling\n \
amount, the DPI setting, and the X and Y margins that can be specified in\n \
the Image/Layer Options page.  For example, the default for DPI is 72 pixels\n \
and both margins default to 10 pixels which means the overall size of the\n \
bounding box will be 92x92 pixels (remember that the scaling default is\n \
1.0).\n \
\n \
Image/Layer Options\n \
\n \
The second page of the ArrowGFX dialog allows you to specify\n \
options related to the layer and image into which the arrow will\n \
be drawn.  This page is divided into three sections:  Draw To, Drawing\n \
Margins, and New Layer Options.  Each section is enclosed by a framed\n \
outline so it should be easy to follow this next section.\n \
\n \
The Draw To frame has three mutually exclusive toggle buttons:  New Layer,\n \
To Original, and To Mask.  Selecting New Layer causes the arrow to be drawn\n \
on a new layer that will be positioned on top of all the other layers for\n \
the currently selected image (which can be set using the Available Images\n \
option menu to the right of the Draw To frame).  Selecting the To Original\n \
button will cause the arrow to be written over the currently active layer in\n \
the selected image.  This option is destructive to the contents of the\n \
current layer so be certain this is really what you want to do.  The other\n \
option, To Mask, will cause the arrow to be drawn to the mask of the active\n \
layer for the selected image.  If a mask does not exist then one will be\n \
created for that layer.  Keep in mind that a mask is a grayscale image so\n \
the current foreground color is not used in the mask.\n \
\n \
If a new layer is to be created then the options in the New Layer Options\n \
frame become active.  If To Original or To Mask is selected then these\n \
options cannot be modified (they are said to be \"grayed out\").  The first\n \
two options, Blend Mode and Opacity, allow you to specify the initial\n \
settings for the new layer just as you would otherwise do using the Layer\n \
and Channels dialog.  The X and Y Offset options allow you to position the\n \
new layer within the selected image.  These offsets are relative to the\n \
upper left corner of the Image Window for the specified image.\n \
\n \
Finally, the Drawing Margins options allow you to add a bit of padding to\n \
the left and top of the bounding box in which the arrow will be drawn.\n \
Setting the margins may be necessary for some arrows under some rotational\n \
angles to prevent the ends of the tail or tips of the arrow head from being\n \
cut off.\n \
\n \
Drawing Options\n \
\n \
The final page provides options for how the arrow will be drawn or\n \
painted.  This page has three sections, plus two additional\n \
options.  The three sections are Draw With, Fill Type, and Tail.  The Draw\n \
With options allow you to select the GIMP drawing tool to use.  The tool\n \
selected, one of Pencil, Paintbrush, Airbrush or Stroke Outline, will use\n \
the currently selected brush from the Brush Selection dialog so be sure\n \
you've selected your brush first.  The Paintbrush tool has an additional\n \
option, Paintbrush Fade Out which is identical in use to the Fade Out option\n \
of the Paintbrush Tool Options dialog.  It determines how quickly the\n \
paintbrush fades as it draws.  The default setting of 0 (zero) means the\n \
paintbrush will not fade at all.  Smaller values greater than zero mean the\n \
paintbrush fades quickly as it draws.  Larger values mean it paints longer\n \
lines before it begins to fade.  Similarly, the Airbrush tool has an\n \
Airbrush Pressure option that functions the same as its Tool Options feature\n \
of the same name.  Both of these options are only active (modifiable) when\n \
their respective tools are selected from the Draw With frame.\n \
\n \
Arrows are drawn in two steps - first their outline is drawn using the\n \
selected drawing tool and then this outline is filled, or not, using the\n \
method specified by the Fill Type frame.  The default is to fill the arrow\n \
with the same color as its outline.  Alternatively you can fill the outline\n \
with the currently selected Pattern, fill the outline with the pattern but\n \
leave off the drawn outline, or just outline the arrow shape.\n \
\n \
The last frame involves the drawing of the arrow's tail.  It can either be\n \
drawn or not drawn depending on which toggle is set in the Tail frame.\n \
\n \
Drawing the Selected Arrow\n \
\n \
Once you've made all your modifications to the default settings of the\n \
dialog you can click on the OK button at the bottom of the window.  The\n \
arrow will be created fairly quickly even if its fairly large.  If the arrow\n \
is drawn on a new layer then that layer will be named GFXArrow.\n \
\n \
Closing and Resetting the Dialog\n \
The ArrowGFX dialog will not close after you click on OK.  It stays open so\n \
you can create multiple arrows if you so desire.  To close the dialog, click\n \
on the Cancel button.  If you need to start over with the original default\n \
dialog settings you can simply click on the Reset button and all the\n \
original settings of the dialog will be restored.\n \
\n \
"
#endif /* HELP_H */

