/* $Id$ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1998.
 *========================================================================
 *              FILE NAME: page2.c
 *            DESCRIPTION: notebook page 2 related routines
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *       PUBLIC FUNCTIONS: 
 *      PRIVATE FUNCTIONS: 
 *  SOFTWARE DEPENDENCIES: 
 *  HARDWARE DEPENDENCIES: 
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/
#define PAGE2_C

/* === System Headers === */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <math.h>

/*
 * Assumes we have the GTK and gimp.h installed in places that the compiler
 * knows how to find or that we've specified where to find them using the
 * Makefile.
 */
#include <gtk/gtk.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>


/* === Project Headers === */
#include "arrows.h"
#include "gfxcommon.h"
#include "debug.h"


/* === external routines === */
extern void GFXMsgWindow();
extern void GFXMsgWindowUpdate();
extern void GFXCenterWindow();
extern void GFXSizeSelect();


/* === Public routine prototypes === */
gint GFXImageConstraints();
void GFXImageSelect();
void GFXBlendSelect();
void GFXOpacityTextUpdate();
void GFXOpacitySliderUpdate();
void GFXRebuildImageMenu();


/* === Private routine prototypes === */


/* === Global Variables === */
extern GtkWidget		*opacity_text;
extern GtkWidget		*opacity_slider;
extern GtkObject		*opacity_adj;
extern GtkWidget		*offset_x_text;
extern GtkWidget		*offset_x_slider;
extern GtkObject		*offset_x_adj;
extern GtkWidget		*offset_y_text;
extern GtkWidget		*offset_y_slider;
extern GtkObject		*offset_y_adj;
extern GtkWidget		*margin_x_text;
extern GtkWidget		*margin_x_slider;
extern GtkObject		*margin_x_adj;
extern GtkWidget		*margin_y_text;
extern GtkWidget		*margin_y_slider;
extern GtkObject		*margin_y_adj;
extern GtkWidget		*blend_menu;
extern GtkWidget		*image_options;
extern GtkWidget		*image_menu;
extern int				size_type;

extern int	image_id;		/* ID of image initial layer lives in */
extern int	blend_mode;		/* NORMAL mode by default for new layers */
extern int	selected_index;
extern int	keypress;


/*========================================================================
 *	Name:			GFXRebuildImageMenu
 *	Prototype:	void GFXRebuildImageMenu()
 *					
 *	Description:
 *		Rebuild the image options menu.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXRebuildImageMenu()
{
	gtk_widget_hide(image_options);
	gtk_widget_destroy(image_menu);
	image_menu = gimp_image_menu_new(GFXImageConstraints,
					GFXImageSelect,
					NULL,
					image_id);
	gtk_option_menu_set_menu(GTK_OPTION_MENU(image_options), image_menu);
	gtk_widget_show(image_options);
}


/*========================================================================
 *	Name:			GFXImageConstraints
 *	Prototype:	gint GFXImageConstraints()
 *					
 *	Description:
 *		Callback used to determine which image we'll include in our
 *		menu of images.  Basically, we include all of them.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
gint
GFXImageConstraints(
	gint32	cb_image_id, 
	gint32	drawable_id, 
	gpointer	data
)
{
	/* No real constraints at this point */
	return TRUE;
}


/*========================================================================
 *	Name:			GFXImageSelect
 *	Prototype:	void GFXImageSelect()
 *					
 *	Description:
 *		What to do when the user selects a particular image from the menu.
 *		Basically, just save the id of that image.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXImageSelect(
	gint32 	id, 
	gpointer	data
)
{
	image_id = (int)id;
}


/*========================================================================
 *	Name:			GFXBlendSelect
 *	Prototype:	void GFXBlendSelect()
 *					
 *	Description:
 *	Set the blend mode to the user selected value.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXBlendSelect(
	gint32 	id, 
	gpointer	data
)
{
	blend_mode = (int) data;
}


/*========================================================================
 *	Name:			GFXOpacityTextUpdate
 *	Prototype:	void GFXOpacityTextUpdate()
 *					
 *	Description:
 *		Handle updates from Opacity text widget.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXOpacityTextUpdate(
	GtkWidget	*widget,
	gpointer		data
)
{
	gfloat	newvalue;

	/*
	 * Block signals and prevent other routines from updating the
	 * input field  while we're doing this update.
	 */
	gtk_signal_handler_block_by_func (GTK_OBJECT (opacity_text), 
		(GtkSignalFunc) GFXOpacityTextUpdate, (gpointer)NULL);
	keypress = TRUE;

	newvalue = atof(gtk_entry_get_text(GTK_ENTRY(widget)));

	if ((newvalue >= GTK_ADJUSTMENT(opacity_adj)->lower) &&
		(newvalue < GTK_ADJUSTMENT(opacity_adj)->upper))
	{
		GTK_ADJUSTMENT(opacity_adj)->value = newvalue;
		gtk_signal_emit_by_name(opacity_adj, "value_changed");
	}

	keypress = FALSE;
	gtk_signal_handler_unblock_by_func (GTK_OBJECT (opacity_text), 
		(GtkSignalFunc) GFXOpacityTextUpdate, (gpointer)NULL);
}


/*========================================================================
 *	Name:			GFXOpacitySliderUpdate
 *	Prototype:	void GFXOpacitySliderUpdate()
 *					
 *	Description:
 *		Handle updates from Opacity scale widget.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXOpacitySliderUpdate(
	GtkAdjustment	*adjustment
)
{
	char		buf[32];

	if (keypress)
		return;

	sprintf(buf, "%.1f", adjustment->value);

	gtk_signal_handler_block_by_data(GTK_OBJECT(opacity_text), NULL);
	gtk_entry_set_text(GTK_ENTRY(opacity_text), buf);
	gtk_signal_handler_unblock_by_data(GTK_OBJECT(opacity_text), NULL);
}


/*========================================================================
 *	Name:			GFXOffsetXTextUpdate
 *	Prototype:	void GFXOffsetXTextUpdate()
 *					
 *	Description:
 *		Handle updates from OffsetX text widgets.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXOffsetXTextUpdate(
	GtkWidget	*widget,
	gpointer		data
)
{
	gfloat			newvalue;

	/*
	 * Block signals and prevent other routines from updating the
	 * input field  while we're doing this update.
	 */
	gtk_signal_handler_block_by_func (GTK_OBJECT (offset_x_text), 
		(GtkSignalFunc) GFXOffsetXTextUpdate, (gpointer)NULL);
	keypress = TRUE;

	newvalue = atof(gtk_entry_get_text(GTK_ENTRY(widget)));

	if ((newvalue >= GTK_ADJUSTMENT(offset_x_adj)->lower) &&
		(newvalue < GTK_ADJUSTMENT(offset_x_adj)->upper))
	{
		GTK_ADJUSTMENT(offset_x_adj)->value = newvalue;
		gtk_signal_emit_by_name(offset_x_adj, "value_changed");
	}

	keypress = FALSE;
	gtk_signal_handler_unblock_by_func (GTK_OBJECT (offset_x_text), 
		(GtkSignalFunc) GFXOffsetXTextUpdate, (gpointer)NULL);
}


/*========================================================================
 *	Name:			GFXOffsetXSliderUpdate
 *	Prototype:	void GFXOffsetXSliderUpdate()
 *					
 *	Description:
 *		Handle updates from OffsetX scale widget.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXOffsetXSliderUpdate(
	GtkAdjustment	*adjustment
)
{
	char			buf[32];

	if (keypress)
		return;

	sprintf(buf, "%.1f", adjustment->value);

	gtk_signal_handler_block_by_data(GTK_OBJECT(offset_x_text), NULL);
	gtk_entry_set_text(GTK_ENTRY(offset_x_text), buf);
	gtk_signal_handler_unblock_by_data(GTK_OBJECT(offset_x_text), NULL);
}


/*========================================================================
 *	Name:			GFYOffsetYTextUpdate
 *	Prototype:	void GFYOffsetYTextUpdate()
 *					
 *	Description:
 *		Handle updates from OffsetY text widgets.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXOffsetYTextUpdate(
	GtkWidget	*widget,
	gpointer		data
)
{
	gfloat			newvalue;

	/*
	 * Block signals and prevent other routines from updating the
	 * input field  while we're doing this update.
	 */
	gtk_signal_handler_block_by_func (GTK_OBJECT (offset_y_text), 
		(GtkSignalFunc) GFXOffsetYTextUpdate, (gpointer)NULL);
	keypress = TRUE;

	newvalue = atof(gtk_entry_get_text(GTK_ENTRY(widget)));

	if ((newvalue >= GTK_ADJUSTMENT(offset_y_adj)->lower) &&
		(newvalue < GTK_ADJUSTMENT(offset_y_adj)->upper))
	{
		GTK_ADJUSTMENT(offset_y_adj)->value = newvalue;
		gtk_signal_emit_by_name(offset_y_adj, "value_changed");
	}

	keypress = FALSE;
	gtk_signal_handler_unblock_by_func (GTK_OBJECT (offset_y_text), 
		(GtkSignalFunc) GFXOffsetYTextUpdate, (gpointer)NULL);
}


/*========================================================================
 *	Name:			GFYOffsetYSliderUpdate
 *	Prototype:	void GFYOffsetYSliderUpdate()
 *					
 *	Description:
 *		Handle updates from OffsetY scale widget.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXOffsetYSliderUpdate(
	GtkAdjustment	*adjustment
)
{
	char			buf[32];

	if (keypress)
		return;

	sprintf(buf, "%.1f", adjustment->value);

	gtk_signal_handler_block_by_data(GTK_OBJECT(offset_y_text), NULL);
	gtk_entry_set_text(GTK_ENTRY(offset_y_text), buf);
	gtk_signal_handler_unblock_by_data(GTK_OBJECT(offset_y_text), NULL);
}


/*========================================================================
 *	Name:			GFXMarginXTextUpdate
 *	Prototype:	void GFXMarginXTextUpdate()
 *					
 *	Description:
 *		Handle updates from MarginX text widgets.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXMarginXTextUpdate(
	GtkWidget	*widget,
	gpointer		data
)
{
	gfloat			newvalue;

	/*
	 * Block signals and prevent other routines from updating the
	 * input field  while we're doing this update.
	 */
	gtk_signal_handler_block_by_func (GTK_OBJECT (margin_x_text), 
		(GtkSignalFunc) GFXMarginXTextUpdate, (gpointer)NULL);
	keypress = TRUE;

	newvalue = atof(gtk_entry_get_text(GTK_ENTRY(widget)));

	if ((newvalue >= GTK_ADJUSTMENT(margin_x_adj)->lower) &&
		(newvalue < GTK_ADJUSTMENT(margin_x_adj)->upper))
	{
		GTK_ADJUSTMENT(margin_x_adj)->value = newvalue;
		gtk_signal_emit_by_name(margin_x_adj, "value_changed");
	}

	/*
	 * Allow other updates and signals to proceed now.
	 */
	keypress = FALSE;
	gtk_signal_handler_unblock_by_func (GTK_OBJECT (margin_x_text), 
		(GtkSignalFunc) GFXMarginXTextUpdate, (gpointer)NULL);
}


/*========================================================================
 *	Name:			GFXMarginXSliderUpdate
 *	Prototype:	void GFXMarginXSliderUpdate()
 *					
 *	Description:
 *		Handle updates from MarginX scale widget.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXMarginXSliderUpdate(
	GtkAdjustment	*adjustment
)
{
	char			buf[32];

	if (keypress)
		return;

	sprintf(buf, "%.1f", adjustment->value);

	gtk_signal_handler_block_by_data(GTK_OBJECT(margin_x_text), NULL);
	gtk_entry_set_text(GTK_ENTRY(margin_x_text), buf);
	gtk_signal_handler_unblock_by_data(GTK_OBJECT(margin_x_text), NULL);

	/*
	 * Update size display.
	 */
	if (selected_index != 0 )
		GFXSizeSelect(0, (gpointer)size_type);
}


/*========================================================================
 *	Name:			GFYMarginYTextUpdate
 *	Prototype:	void GFYMarginYTextUpdate()
 *					
 *	Description:
 *		Handle updates from MarginY text widgets.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXMarginYTextUpdate(
	GtkWidget	*widget,
	gpointer		data
)
{
	gfloat			newvalue;

	/*
	 * Block signals and prevent other routines from updating the
	 * input field  while we're doing this update.
	 */
	gtk_signal_handler_block_by_func (GTK_OBJECT (margin_y_text), 
		(GtkSignalFunc) GFXMarginYTextUpdate, (gpointer)NULL);
	keypress = TRUE;

	newvalue = atof(gtk_entry_get_text(GTK_ENTRY(widget)));

	if ((newvalue >= GTK_ADJUSTMENT(margin_y_adj)->lower) &&
		(newvalue < GTK_ADJUSTMENT(margin_y_adj)->upper))
	{
		GTK_ADJUSTMENT(margin_y_adj)->value = newvalue;
		gtk_signal_emit_by_name(margin_y_adj, "value_changed");
	}

	/*
	 * Allow other updates and signals to proceed now.
	 */
	keypress = FALSE;
	gtk_signal_handler_unblock_by_func (GTK_OBJECT (margin_y_text), 
		(GtkSignalFunc) GFXMarginYTextUpdate, (gpointer)NULL);
}


/*========================================================================
 *	Name:			GFYMarginYSliderUpdate
 *	Prototype:	void GFYMarginYSliderUpdate()
 *					
 *	Description:
 *		Handle updates from MarginY scale widget.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXMarginYSliderUpdate(
	GtkAdjustment	*adjustment
)
{
	char			buf[32];

	if (keypress)
		return;

	sprintf(buf, "%.1f", adjustment->value);

	gtk_signal_handler_block_by_data(GTK_OBJECT(margin_y_text), NULL);
	gtk_entry_set_text(GTK_ENTRY(margin_y_text), buf);
	gtk_signal_handler_unblock_by_data(GTK_OBJECT(margin_y_text), NULL);

	/*
	 * Update size display.
	 */
	if (selected_index != 0 )
		GFXSizeSelect(0, (gpointer)size_type);
}
