/* $Id$ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1998.
 *========================================================================
 *              FILE NAME: page3.c
 *            DESCRIPTION: notebook page 3 related routines
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *       PUBLIC FUNCTIONS: 
 *      PRIVATE FUNCTIONS: 
 *  SOFTWARE DEPENDENCIES: 
 *  HARDWARE DEPENDENCIES: 
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/
#define PAGE3_C

/* === System Headers === */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <math.h>

/*
 * Assumes we have the GTK and gimp.h installed in places that the compiler
 * knows how to find or that we've specified where to find them using the
 * Makefile.
 */
#include <gtk/gtk.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>


/* === Project Headers === */
#include "arrows.h"
#include "gfxcommon.h"
#include "debug.h"


/* === external routines === */
extern void GFXMsgWindow();
extern void GFXMsgWindowUpdate();
extern void GFXCenterWindow();


/* === Public routine prototypes === */
void GFXToolToggle();
void GFXFillToggle();
void GFXAirbrushTextUpdate();
void GFXAirbrushSliderUpdate();
void GFXPaintbrushTextUpdate();
void GFXPaintbrushSliderUpdate();


/* === Private routine prototypes === */


/* === Global Variables === */
extern GtkWidget		*airbrush_text;
extern GtkWidget		*airbrush_slider;
extern GtkObject		*airbrush_adj;
extern GtkWidget		*paintbrush_text;
extern GtkWidget		*paintbrush_slider;
extern GtkObject		*paintbrush_adj;

extern int fill_type;
extern int tool_type;
extern int tail_status;
extern int keypress;



/*========================================================================
 *	Name:			GFXToolToggle
 *	Prototype:	void GFXToolToggle()
 *					
 *	Description:
 *		Toggle tool selection.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXToolToggle(
	GtkWidget	*widget,
	gpointer		data
)
{
	switch ((int)data)
	{
		case ARROWGFX_TYPE_PENCIL: 
			tool_type = ARROWGFX_TYPE_PENCIL;
			gtk_widget_set_sensitive(paintbrush_text, FALSE);
			gtk_widget_set_sensitive(paintbrush_slider, FALSE);
			gtk_widget_set_sensitive(airbrush_text, FALSE);
			gtk_widget_set_sensitive(airbrush_slider, FALSE);
			break;

		case ARROWGFX_TYPE_PAINTBRUSH: 
			tool_type = ARROWGFX_TYPE_PAINTBRUSH;
			gtk_widget_set_sensitive(paintbrush_text, TRUE);
			gtk_widget_set_sensitive(paintbrush_slider, TRUE);
			gtk_widget_set_sensitive(airbrush_text, FALSE);
			gtk_widget_set_sensitive(airbrush_slider, FALSE);
			break;

		case ARROWGFX_TYPE_AIRBRUSH: 
			tool_type = ARROWGFX_TYPE_AIRBRUSH;
			gtk_widget_set_sensitive(paintbrush_text, FALSE);
			gtk_widget_set_sensitive(paintbrush_slider, FALSE);
			gtk_widget_set_sensitive(airbrush_text, TRUE);
			gtk_widget_set_sensitive(airbrush_slider, TRUE);
			break;

		case ARROWGFX_TYPE_STROKE: 
			tool_type = ARROWGFX_TYPE_STROKE;
			gtk_widget_set_sensitive(paintbrush_text, FALSE);
			gtk_widget_set_sensitive(paintbrush_slider, FALSE);
			gtk_widget_set_sensitive(airbrush_text, FALSE);
			gtk_widget_set_sensitive(airbrush_slider, FALSE);
			break;
	}
}


/*========================================================================
 *	Name:			GFXFillToggle
 *	Prototype:	void GFXFillToggle()
 *					
 *	Description:
 *		Toggle tool selection.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXFillToggle(
	GtkWidget	*widget,
	gpointer		data
)
{
	switch ((int)data)
	{
		case ARROWGFX_TYPE_FILL: 
			fill_type = ARROWGFX_TYPE_FILL;
			break;

		case ARROWGFX_TYPE_PATTERN: 
			fill_type = ARROWGFX_TYPE_PATTERN;
			break;

		case ARROWGFX_TYPE_PATTERN_OL: 
			fill_type = ARROWGFX_TYPE_PATTERN_OL;
			break;

		case ARROWGFX_TYPE_OUTLINE: 
			fill_type = ARROWGFX_TYPE_OUTLINE;
			break;
	}
}


/*========================================================================
 *	Name:			GFXTailToggle
 *	Prototype:	void GFXTailToggle()
 *					
 *	Description:
 *		Toggle tool selection.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXTailToggle(
	GtkWidget	*widget,
	gpointer		data
)
{
	switch ((int)data)
	{
		case ARROWGFX_TYPE_DRAW: 
			tail_status = ARROWGFX_TYPE_DRAW;
			break;

		case ARROWGFX_TYPE_DONT_DRAW: 
			tail_status = ARROWGFX_TYPE_DONT_DRAW;
			break;
	}
}


/*========================================================================
 *	Name:			GFXAirbrushTextUpdate
 *	Prototype:	void GFXAirbrushTextUpdate()
 *					
 *	Description:
 *		Handle updates from Airbrush text widget.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXAirbrushTextUpdate(
	GtkWidget	*widget,
	gpointer		data
)
{
	gfloat	newvalue;

	/*
	 * Block signals and prevent other routines from updating the
	 * input field  while we're doing this update.
	 */
	gtk_signal_handler_block_by_func (GTK_OBJECT (airbrush_text), 
		(GtkSignalFunc) GFXAirbrushTextUpdate, (gpointer)NULL);
	keypress = TRUE;

	newvalue = atof(gtk_entry_get_text(GTK_ENTRY(widget)));

	if ((newvalue >= GTK_ADJUSTMENT(airbrush_adj)->lower) &&
		(newvalue < GTK_ADJUSTMENT(airbrush_adj)->upper))
	{
		GTK_ADJUSTMENT(airbrush_adj)->value = newvalue;
		gtk_signal_emit_by_name(airbrush_adj, "value_changed");
	}

	keypress = FALSE;
	gtk_signal_handler_unblock_by_func (GTK_OBJECT (airbrush_text), 
		(GtkSignalFunc) GFXAirbrushTextUpdate, (gpointer)NULL);
}


/*========================================================================
 *	Name:			GFXAirbrushSliderUpdate
 *	Prototype:	void GFXAirbrushSliderUpdate()
 *					
 *	Description:
 *		Handle updates from Airbrush scale widget.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXAirbrushSliderUpdate(
	GtkAdjustment	*adjustment
)
{
	char		buf[32];

	if (keypress)
		return;

	sprintf(buf, "%.1f", adjustment->value);

	gtk_signal_handler_block_by_data(GTK_OBJECT(airbrush_text), NULL);
	gtk_entry_set_text(GTK_ENTRY(airbrush_text), buf);
	gtk_signal_handler_unblock_by_data(GTK_OBJECT(airbrush_text), NULL);
}


/*========================================================================
 *	Name:			GFXPaintbrushTextUpdate
 *	Prototype:	void GFXPaintbrushTextUpdate()
 *					
 *	Description:
 *		Handle updates from Paintbrush text widget.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXPaintbrushTextUpdate(
	GtkWidget	*widget,
	gpointer		data
)
{
	gfloat	newvalue;

	/*
	 * Block signals and prevent other routines from updating the
	 * input field  while we're doing this update.
	 */
	gtk_signal_handler_block_by_func (GTK_OBJECT (paintbrush_text), 
		(GtkSignalFunc) GFXPaintbrushTextUpdate, (gpointer)NULL);
	keypress = TRUE;

	newvalue = atof(gtk_entry_get_text(GTK_ENTRY(widget)));

	if ((newvalue >= GTK_ADJUSTMENT(paintbrush_adj)->lower) &&
		(newvalue < GTK_ADJUSTMENT(paintbrush_adj)->upper))
	{
		GTK_ADJUSTMENT(paintbrush_adj)->value = newvalue;
		gtk_signal_emit_by_name(paintbrush_adj, "value_changed");
	}

	keypress = FALSE;
	gtk_signal_handler_unblock_by_func (GTK_OBJECT (paintbrush_text), 
		(GtkSignalFunc) GFXPaintbrushTextUpdate, (gpointer)NULL);
}


/*========================================================================
 *	Name:			GFXPaintbrushSliderUpdate
 *	Prototype:	void GFXPaintbrushSliderUpdate()
 *					
 *	Description:
 *		Handle updates from Paintbrush scale widget.
 *
 *	Input Arguments:
 *	Output Arguments:
 *	Return Values:
 *	Method:
 *	Restrictions:
 *========================================================================*/
void
GFXPaintbrushSliderUpdate(
	GtkAdjustment	*adjustment
)
{
	char		buf[32];

	if (keypress)
		return;

	sprintf(buf, "%.1f", adjustment->value);

	gtk_signal_handler_block_by_data(GTK_OBJECT(paintbrush_text), NULL);
	gtk_entry_set_text(GTK_ENTRY(paintbrush_text), buf);
	gtk_signal_handler_unblock_by_data(GTK_OBJECT(paintbrush_text), NULL);
}
