/* $Id$ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1998.
 *========================================================================
 *              FILE NAME: bcards.h
 *            DESCRIPTION: main header file for Business Cards plug-in
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *       PUBLIC FUNCTIONS: 
 *      PRIVATE FUNCTIONS: 
 *  SOFTWARE DEPENDENCIES: 
 *  HARDWARE DEPENDENCIES: 
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/
#ifndef BCARDS_H
#define BCARDS_H

/*
 * Information used by gimp_install_procedure() in the BCardsQuery() 
 * routine.
 */
#define BCARDS_NAME			"plugin-gfxcards"
#define BCARDS_BLURB			"Build business and greeting cards from a single image"
#define BCARDS_HELP			BCARDS_BLURB
#define BCARDS_AUTHOR		"Michael J. Hammel <mjhammel@graphics-muse.org>"
#define BCARDS_COPYRIGHT	"Private License - Copyright 1998 Michael J.  Hammel"
#define BCARDS_DATE			"1998/10/05"
#define BCARDS_MENU_PATH	"<Image>/Filters/GFXMuse/CardGFX"
#define BCARDS_IMAGE_TYPES	"RGB*,GRAY*,INDEXED*"
#define BCARDS_PROC_TYPE	GIMP_PLUGIN

/*
 * The name to use for saving configuration data
 */
#define BCARDS_PI_NAME		"CardGFX"

/*
 * Title and Version information for our dialogs.
 */
#define BCARDS_TITLE			"CardGFX "
#define BCARDS_VERSION		"0.1"

/*
 * Size of the preview window.  Try to keep a 8.5:11 (w:h) ratio
 */
#define PREVIEW_HSIZE				200
#define PREVIEW_WSIZE				170
#define IMAGE_PREVIEW_HSIZE		200
#define IMAGE_PREVIEW_WSIZE		200

#define PAGE_HEIGHT_DEFAULT		11.0
#define PAGE_WIDTH_DEFAULT			8.5
#define MARGIN_TOP_DEFAULT			0.25
#define MARGIN_BOTTOM_DEFAULT		0.125
#define MARGIN_LEFT_DEFAULT		0.125
#define MARGIN_RIGHT_DEFAULT		0.125
#define IMARGIN_TOP_DEFAULT		0.100
#define IMARGIN_BOTTOM_DEFAULT	0.100
#define IMARGIN_LEFT_DEFAULT		0.100
#define IMARGIN_RIGHT_DEFAULT		0.100
#define SHARPEN_DEFAULT				0
#define PRINTER_DPI_DEFAULT		360
#define ROWS_DEFAULT					5
#define COLUMNS_DEFAULT				3

/*
 * On/Off states.
 */
#define ON		1
#define OFF		2

/*
 * Identifiers for Margin radio buttons.
 */
#define BCARDS_TOPMARGIN		1
#define BCARDS_BOTTOMMARGIN	2
#define BCARDS_LEFTMARGIN		3
#define BCARDS_RIGHTMARGIN		4

/*
 * Identifiers for text field updates routine.
 */
#define BCARDS_PAGE_WIDTH_FIELD				1
#define BCARDS_PAGE_HEIGHT_FIELD				2
#define BCARDS_PAGE_TOP_MARGIN_FIELD		3
#define BCARDS_PAGE_BOTTOM_MARGIN_FIELD	4
#define BCARDS_PAGE_LEFT_MARGIN_FIELD		5
#define BCARDS_PAGE_RIGHT_MARGIN_FIELD		6

/*
 * Help Text for CardGFX.
 */
#include "help.h"

#endif /* BCARDS_H */
