/* $Id$ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1998.
 *========================================================================
 *              FILE NAME: help.h
 *            DESCRIPTION: Help text for CardGFX plug-in
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *       PUBLIC FUNCTIONS: 
 *      PRIVATE FUNCTIONS: 
 *  SOFTWARE DEPENDENCIES: 
 *  HARDWARE DEPENDENCIES: 
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/
#ifndef HELP_H
#define HELP_H

#define GFX_HELP_TEXT	\
"\n\
\n\
                                                   The Graphics Muse Tools\n\
                                                           \"CardGFX\"\n\
\n\
CardGFX Online Help\n\
\n\
Welcome to CardGFX Online from The Graphics Muse!.  CardGFX is a plug-in for\n\
the GIMP that lets you easily convert a single image into a format suitable\n\
for printing on Business and Greeting Card stock or regular paper.  You can\n\
determine page characteristics such as width and size and printer resolution\n\
as well as set the number of rows and columns your card stock contains.  You\n\
can also get an idea of how big an image to create before you start!\n\
\n\
CardGFX works by copying an existing image and scaling it to fit a single\n\
card, based on the size of the page and the number of rows and columns on\n\
the page.  It then creates a new image window.  The scaled copy of the\n\
original image is sharpened, if requested, and copied to the appropriate\n\
spots on the new image.  Borders are added, also if requested, right before\n\
the new image window is displayed.  All thats left is for you is to print\n\
the new image!\n\
\n\
Table of Contents\n\
\n\
  1. Getting Started\n\
  2. The Grid/Image Options\n\
  3. Using the Page Adjustments Frame\n\
  4. Using the Adjust Grid Square Margins frame\n\
  5. Resetting Options To Their Initial Settings\n\
  6. Running CardGFX, Showing Status and Closing The Window\n\
  7. Possible User Errors\n\
  8. Finding Out How Big To Make Your Original Source Image\n\
  9. Tips\n\
 10. Limitations\n\
\n\
\n\
Getting Started\n\
\n\
Before getting started we should get a little terminology under our belt.\n\
First, I'll be referring to each element in a row/column of the final image\n\
as a \"grid square\".  Each grid square is essentially one business card or\n\
one side of a greeting card, for example.  A grid square also has adjustable\n\
\"grid margins\".  The original image will be scaled to fit into a single grid\n\
square and within the specified grid margins.  The grid margins are\n\
different from the \"page margins\".  Page margins are the areas between the\n\
edge of the paper and where the grid squares begin.  Got all that?  Ok, lets\n\
see how to use CardGFX.\n\
\n\
The CardGFX interface is fairly intuitive.  First, there are two pages in\n\
the opening dialog: Page Options and Grid/Image Options.  The first page,\n\
Page Options, allows you to configure how your printed page is set up.\n\
Starting in the upper left corner of this page you'll find the Page\n\
Adjustments frame (frames are outlined with a thin, raised line).  This\n\
frame displays both the current page configuration information as well as\n\
allows you to interactively update the page width, height and margins.  More\n\
on using this frame a little later.\n\
\n\
To the right of the Page Adjustements, just below the Graphics Muse logo,\n\
are the Page Dimensions width and height input fields.  You can type page\n\
dimensions in these fields if you want, or they will automatically be\n\
udpated when you make changes in the Page Adjustments frame.\n\
\n\
Below the Page Dimensions fields are the Row and Columns settings.  Clicking\n\
on the arrow buttons will increase or decrease the numbers of rows or\n\
columns.  Below these are two buttons labeled \"Select All\" and \"Clear All\".\n\
These buttons are used to select or deselect all the grid squares in the\n\
Page Adjustments frame.  More on what selecting a grid square means when we\n\
talk about using the Page Adjustement frame a little later.\n\
\n\
Below the Page Adjustments frame is an informational field showing the\n\
Projected Size that the new image will be in kilobytes (1024 bytes) when it\n\
is created.  The default shows an image size of 11.822MB - quite large but\n\
this is necessary to get a reasonable print image at the default resolution\n\
of 360 DPI.  This information is displayed to give you an idea of the amount\n\
of memory you  will be using to create the new image.  Note that CardGFX,\n\
like most tools used to generate printable images, is quite a memory hog.\n\
\n\
Images destined for a printer need to be created based on the printer\n\
resolution, not the screen resolution.  Computer monitors use 72 Dots Per\n\
Inch (DPI) but printers can use up to 1400 DPI or more.  The Printers DPI\n\
frame allows you to specify the printers DPI using either the slider or the\n\
text input field, whichever you prefer.  The DPI setting is used to\n\
calculate how large to scale the copy of the original image in order to fit\n\
into the grid square inside the grid margins.  You can see how large this\n\
scaled copy will be by looking at the Suggested Size inside the Source Image\n\
frame, just below the Printers DPI frame.  This information is useful\n\
because you would, optimally, like to create the original image at the\n\
suggested size so that scaling is kept to a minimum.  Excessive scaling will\n\
distort the original as it will appear in the new image window.\n\
\n\
The last frame of the Page Options page is the Page Margins frame.  These\n\
four fields can be used to manually specify the margins on the printed\n\
page.  The toggle buttons are used to select the active margin in the Page\n\
Adjustements frame.  Again, we'll cover this frame in more detail after we\n\
talk about the Grid/Page Options page.\n\
\n\
\n\
The Grid/Image Options\n\
\n\
The second page provides fewer options and is used to specify\n\
configuration options for individual grid squares.  Like the first\n\
page, this page offers a preview frame, labeled Adjust Grid Square Options,\n\
with margin settings.  To the right of this frame is the Grid Square Margins\n\
frame.  Like its counterpart on the first page, this frame offers the user a\n\
chance to adjust margins except this time the margins are in the individual\n\
grid squares.\n\
\n\
Below the Grid Square Margins frame are the adjustments for sharpening the\n\
copy of the original image. Sharpening of the image can be used for special\n\
effects but it can also be used clean up the image copy when excessive\n\
scaling has been performed.\n\
\n\
The grid square margins can be used as a boundary around the image copy in\n\
the final image.  To draw this boundary you need only select the \"Add Border\n\
To Margin Line\" toggle, just below the Sharpen Amount frame.  This border is\n\
drawn last, after the image copy has been sharpened but before the final\n\
image is actually displayed.\n\
\n\
Beneath all these options on the Grid/Image Options page is a menu for\n\
selecting which image to use as the original, source image.  Any image\n\
window can be used, be they RGB, Indexed or Greyscale images.  The source\n\
image need not be the image from which the CardGFX plug-in was started.\n\
\n\
\n\
Using The Page Adjustements Frame\n\
\n\
You can interactively adjust the page size and margins by clicking and\n\
dragging within the framed outline in the Page Adjustments frame in the Page\n\
Options page of the main dialog.  This frame contains the physical page,\n\
represented as the white block, the margins, and the row and column\n\
dividers.  Additionally, you can interactively select which grid squares in\n\
the final image will receive copies of the original image.\n\
\n\
Adjusting The Page Size\n\
\n\
In the upper right corner of the white page you will see a small box\n\
outlined in black.  This is the Page Grab Box.  Clicking within this box\n\
enables the page resize mode for the Page Adjustments frame.  Just click\n\
inside the box and drag the mouse around to watch the page be resized.  You\n\
can see the page dimensions being updated in the Page Width and Page Height\n\
fields to the right of the Page Adjustment frame.  In order to allow finer\n\
adjustments to the page the amount of movement of the mouse does not\n\
correspond exactly to the amount of change in page size, so don't be\n\
suprised if you find the pointer needs to be moved outside of the Grab Box\n\
in order to change the page size a specific amount.\n\
\n\
Margins\n\
\n\
Margins are displayed in the Page Adjustments frame using the horizontal and\n\
vertical lines that extend to the edges of the frame (ie beyond the white\n\
area of the page).  Three of these lines are dashed lines and one is solid -\n\
the solid margin line is the active margin.  Clicking the left mouse button\n\
anywhere within the frame except the Page Grab Box will allow you to drag\n\
the active margin up or down (for the top and bottom margins) or left and\n\
right (for the side margins).  To change the active margin, click on the\n\
appropriate toggle button in the Page Margins frame.  When you click on one\n\
of the toggles the new active margin turns to a solid line and the rest\n\
become dashed lines.  You can also type in margin widths directly in their\n\
respective fields in the Page Margins frame.\n\
\n\
Page margins are specified in inches, since this is likely to be how they\n\
are specified with the paper stock you will be using.  Converting inches\n\
into DPI is simple enough - just multiply the inches by DPI.  However, you\n\
shouldn't need to do such conversions as CardGFX will take care of that for\n\
you.\n\
\n\
Selecting Grid Squares\n\
\n\
CardGFX can be used to create a complete page of cards, such as business\n\
cards, or partial pages.  Greeting card stock is often broken into 4 squares\n\
with printing done on both sides of the stock.  CardGFX lets you select only\n\
the grid squares in which images will go on one side.  To do this, click\n\
with the right or middle (either should work) mouse button inside one of the\n\
grid squares.  A small red circle will be drawn in the selected box.  The\n\
selected squares will be the ones which have copies of the original image\n\
copied into them in the final image.  You can disable squares by clicking on\n\
the square again.  Alternatively you can use the Grid Square Selection\n\
buttons to select or deselect all of the grid squares at one time.\n\
\n\
\n\
Using the Adjust Grid Square Margins frame.\n\
\n\
Using the Adjust Grid Square Margins frame in the Grid/Image Options page is\n\
just like using the Page Adjustements frame on the first page.  The only\n\
differences are that the white page size cannot be changed and there are no\n\
grid square selections here.  Like the Page Adjustments margins, the Grid\n\
Square margins are specified in inches.\n\
\n\
\n\
Resetting Options To Their Initial Settings.\n\
\n\
Resetting options to their default settings can be done by clicking on the\n\
Reset button at the bottom middle of the CardGFX dialog window.  This button\n\
can also be used to update the Source Image menu in the Grid/Image Options\n\
page.  This may be necessary, for example, if you have opened new Image\n\
Windows after having started the CardGFX plug-in.\n\
\n\
Additionally, if you change the number of rows or columns then all selected\n\
grid squares are deselected.  Note that none of the other fields are reset,\n\
although they may be adjusted to reflect the new size of individual grid\n\
squares.\n\
\n\
\n\
Running CardGFX, Showing Status and Closing The Window.\n\
\n\
Once you've made all the adjustments you need to your page just click on the\n\
OK button at the bottom left of the dialog window.  This will start CardGFX\n\
on its way to creating the new image window.  Because the scaling and\n\
copying process can take quite some time, especially on memory limited or\n\
slower processor systems, it is not always obvious that anything is\n\
happening.  If you want to be certain that CardGFX is working, open the\n\
Status Message Dialog before you click on OK.  Click on the Show Status\n\
button to open this dialog.  When you do so a small window will open and the\n\
Show Status button will change to Hide Status.  You can then click on the\n\
same button to hide this new dialog or click on the Close button in the\n\
Message dialog to close that window.  The Status Message dialog is\n\
informational only.  Its just there to make sure you get some idea that\n\
CardGFX hasn't locked up on you while its working!\n\
\n\
CardGFX doesn't work quite like most of the other GIMP plug-ins you are used\n\
to - it doesn't close immediately after you have used it one time.  This way\n\
you can experiment a few times to find the right configuration for your new\n\
image without having to restart the plug-in each time.  To close the window,\n\
simply click on the Close button at the bottom of the main dialog.\n\
Additionally, because the normal GIMP Progress Update dialog cannot be\n\
closed without closing the plug-in dialog the CardGFX plug-in (and all\n\
GFXMuse Tools plug-ins) uses its own Status Message Dialog to show\n\
processing status.\n\
\n\
\n\
Possible User Errors\n\
\n\
CardGFX can use all of its defaults but still requires some input from the\n\
user.  At a minimum, at least one grid square must be selected.  If no grid\n\
squares are selected and the OK button is pressed, CardGFX will present an\n\
error dialog stating what needs to be done (which is to select at least one\n\
grid square).\n\
\n\
Another possible problem is that the currently selected source image, from\n\
the Grid/Image Options page, may no longer exist.  This might happen if you\n\
have closed the Image Window before processing it with CardGFX.  If this\n\
happens, CardGFX will recognize the source image window has gone and pop up\n\
an error dialog.  When it does this it also rebuilds the menu of images in\n\
the Grid/Image Options window.  Simply select another image and proceed as\n\
usual.\n\
\n\
\n\
Finding Out How Big To Make Your Original Source Image\n\
\n\
Since scaling images can cause quite a bit of distortion you may want to\n\
start out by first creating an image that needs little or no rescaling.  To\n\
do this you can open the CardGFX window and make the page adjustments for\n\
your expected output image.  Then look in the Source Image box on the lower\n\
right of the main CardGFX dialog window.  The Current Size shows the size of\n\
the current source image.  The Suggested Size is the size the image should\n\
be if you want to prevent unwanted scaling distortion.  Just make sure your\n\
source image is the suggested size and you'll be ready to rumble!\n\
\n\
\n\
Tips\n\
\n\
  1. In the Print dialog, set the Scaling to use PPI (Pixels Per Inch)\n\
     instead of the default Percentage.  Then adjust the scaling slider to\n\
     the same DPI you used with CardGFX.  This will cause the Print plug-in\n\
     to not add additional margin space to the printed page beyond what you\n\
     specified with CardGFX's Page Margins.  If you don't do this the Print\n\
     Plug-In will try to use the page margins it expects your printer to\n\
     have built in to it.\n\
  2. To experiment with grid square alignment without having to use lots of\n\
     memory (and lots of time), set the DPI to 72 or less and the page size\n\
     to half what you will be using on your printed page.  This will create\n\
     a displayed image that is the same dimensions, but much smaller\n\
     physically and can be computed much more quickly by CardGFX and the\n\
     GIMP.\n\
\n\
Limitations\n\
\n\
  1. CardGFX does not currently run in batch mode.\n\
  2. CardGFX does not currently save run time options between invokations.\n\
  3. The 1.0.x versions of Gtk/GIMP appear to need some form of external\n\
     signalling to continue processing.  At times CardGFX may appear to have\n\
     stopped working when in fact all thats needed is to signal Gtk/GIMP to\n\
     keep going.  To do this, simply move the mouse around the CardGFX\n\
     window, especially over the buttons along the bottom of the main dialog\n\
     window.  This should be enough to kick start GIMP into finishing its\n\
     processing.\n\
\n\
"
#endif /* BCARDS_H */

