/* $Id$ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1995,1996,1997,1998.
 *========================================================================
 *              FILE NAME: generic.c
 *            DESCRIPTION: generic shell window for GFXMuse Tools
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *       PUBLIC FUNCTIONS: GFXCreateGenericShell
 *      PRIVATE FUNCTIONS: 
 *  SOFTWARE DEPENDENCIES: 
 *  HARDWARE DEPENDENCIES: 
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/
#define GFX_GENERIC_C

/* === System Headers === */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/stat.h>

#include <gtk/gtk.h>


/* === Project Headers === */
#include "gfxcommon.h"
#include "debug.h"


/* === external routines === */


/* === Public routine prototypes === */


/* === Private routine prototypes === */


/* === Global Variables === */


/* === Static Variables === */



/*========================================================================
 *	Name:			GFXCreateGenericShell
 *	Prototype:	GtkWidget *GFXCreateGenericShell( char *textstring, 
 *						unsigned int button_types, GShell_T *caller_data,
 *						gboolean usebg )
 *
 *	Description:
 *		This is the basic shell in which most of the other pop up 
 *		windows will be placed.  This gets called each time a new
 *		window needs to be popped up.
 *
 *	Input Arguments:
 *		char 			*textstring			The title to use for the window
 *		gboolean		usebg					TRUE: name the eventbox "label" so it
 *												can be set to have an appropriate bg color
 *												using the gtkrc file.  Most callers set
 *												this to FALSE
 *		GShell_T		*caller_data		widget ides for the various parts of
 *												the generic dialog.
 *		u_char 		button_types		Defines which buttons to include
 *												Valid values are:
 *												0x0001		Accept button
 *												0x0002		Cancel button
 *												0x0004		OK button
 *												0x0008		Overwrite button
 *												0x0010		Append button
 *												0x0020		Help button
 *												0x0040		Print button
 *												0x0080		Yes button
 *												0x0100		Close button
 *												0x0200		No button
 *												0x0400		Search button
 *												0x0fff		All buttons (never used)
 *	Output Arguments:
 *		None.
 *
 *	Return Values:
 *		GtkWidget	*widget_id			The widget id of the shell which will be the
 *												parent of the rest of the windows widgets.
 *
 *	Global Variables:
 *	External Routines:
 *	Method:
 *	Restrictions:
 *	Notes:
 *		All the buttons get named but Gtk 1.0.x doesn't seem to make that
 * 	very helpful for setting styles yet.  Instead, we pass back widget
 *		ids in the GShell_T structure to make it easier to identify components
 *		of the dialog.  For later versions of GTK, here is the info on the 
 *		naming scheme that is used here.
 *
 *		All of these names of these widgets are suffixed by the widget id
 *		of the shell widget (ie the id returned by this routine).
 *		These are the names the caller needs to know:
 *
 *		Widget Name				Purpose
 *		-----------				------------------------------------
 *		GenericForm				the form in which the caller will place
 *									the widgets specific to that caller.
 *		GenericHelpB			The Help button for this shell.
 *		GenericAcceptB			The Accept button for this shell.
 *		GenericCancelB			The Cancel button for this shell.
 *		GenericOverwriteB		The Overwrite button for this shell.
 *		GenericAppendB			The Append button for this shell.
 *
 *		Remember, tack on the widget id of the shell!  For example, if the
 *		shell widget id is 138457 (decimal) then the name of the form widget
 *		for this shell is "GenericForm138457".
 *		
 *========================================================================*/

GtkWidget *
GFXCreateGenericShell(
	char				*textstring,
	unsigned int	button_types,
	GShell_T			*caller_data,
	gboolean			usebg
)
{

#ifdef DEBUG
	char 			fname[]="GFXCreateGenericShell()";
#endif

	char			buf[256];
	char			shellname[256];
	GtkWidget	*shell_id, *inside_form, *callers_form, *callers_frame;
	GtkWidget	*vbox2, *eventbox;
	GtkWidget	*button_frame, *button_form, 
					*button_accept, *button_cancel, *button_overwrite,
					*button_help, *button_append, *label;


	DBGEnter();

	/*
	 * Create the pop up shell
	 */

	/* new version of title bar */
	(void) sprintf ( buf, "%s", textstring );

	/*
	 * The Help window is a special case - we want to force a real
	 * widget name so that we can specify the Help windows default
	 * height/width values in the application defaults file.
	 */
	if ( strcmp(textstring, GFX_S_HELP_DIALOG) == 0 )
		sprintf(shellname, "Help");
	else
		sprintf(shellname, "GenericShell");

	shell_id = gtk_dialog_new();
	gtk_container_border_width (GTK_CONTAINER (shell_id), 5);
	gtk_window_set_title(GTK_WINDOW(shell_id), buf);
	gtk_widget_set_name(shell_id, shellname); 

	gtk_window_set_wmclass(GTK_WINDOW(shell_id), "GFX", "GFX");
	
	gtk_signal_connect (GTK_OBJECT (shell_id), "delete_event",
			GTK_SIGNAL_FUNC (gtk_false), NULL);

	/* create the inside form - this one is hidden from the caller */
	inside_form = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(inside_form);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (shell_id)->action_area),
		inside_form, TRUE, TRUE, 0); 

	/*
	 * create the two frames which define the callers area and the buttons
	 * area.
	 */

	/* create the callers frame */
	eventbox = gtk_event_box_new();
	if ( usebg )
		gtk_widget_set_name(eventbox, "label");
	gtk_widget_show(eventbox);
	gtk_container_add(GTK_CONTAINER(inside_form), eventbox);
	vbox2 = gtk_vbox_new(FALSE, 2);
	gtk_widget_show(vbox2);
	gtk_container_add(GTK_CONTAINER(eventbox), vbox2);
 
	callers_frame = gtk_frame_new("");
	gtk_frame_set_label(GTK_FRAME(callers_frame), NULL);
	gtk_widget_show(callers_frame);
	gtk_box_pack_start(GTK_BOX(vbox2), callers_frame, FALSE, FALSE, 0);

	/* create the buttons frame */
	button_frame = gtk_frame_new("");
	gtk_frame_set_label(GTK_FRAME(button_frame), NULL);
	gtk_widget_show(button_frame);
	gtk_box_pack_start(GTK_BOX(inside_form), button_frame, FALSE, FALSE, 0);

	/*
	 * create the two forms which go inside the frames 
	 * (for widget positioning)
	 */
	sprintf(buf, "GenericForm%d", (int)shell_id);
	callers_form = gtk_vbox_new(FALSE, 0);
	gtk_widget_set_name(callers_form, buf);
	gtk_widget_show(callers_form);
	gtk_container_add(GTK_CONTAINER(callers_frame), callers_form);
	gtk_container_border_width (GTK_CONTAINER (callers_form), 5);

	button_form = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(button_form);
	gtk_container_add(GTK_CONTAINER(button_frame), button_form);


	/* create the buttons in the button area */

	if (	( button_types & ACCEPT_BUTTON ) || ( button_types & PRINT_BUTTON ) ||
			( button_types & OK_BUTTON ) || ( button_types & YES_BUTTON ) ||
			( button_types & SEARCH_BUTTON ) )
	{
		sprintf(buf, "GenericAcceptB%d", (int)shell_id);
		if ( button_types & ACCEPT_BUTTON )
			sprintf(buf, "Accept");
		else
		if ( button_types & PRINT_BUTTON )
			sprintf(buf, "Print");
		else
		if ( button_types & OK_BUTTON )
			sprintf(buf, "Print");
		else
		if ( button_types & YES_BUTTON )
			sprintf(buf, "Yes");
		else
			sprintf(buf, "Search");

		/*
		 * GTK doesn't allow resource settings as easily as with
		 * Xt, so we have to work around it by manually specifing
		 * the label in the button.
		 */
		button_accept = gtk_button_new();
		gtk_widget_set_name(button_accept, "window_button");
		label = gtk_label_new(buf);
		gtk_widget_set_name(label, "window_button");
		gtk_widget_show(label);
		gtk_container_add(GTK_CONTAINER(button_accept), label);
		gtk_box_pack_start (GTK_BOX (button_form), button_accept, 
			FALSE, FALSE, 5);
		gtk_widget_show(button_accept);

		caller_data->accept = button_accept;
	}
	
	if (	( button_types & CANCEL_BUTTON ) || ( button_types & CLOSE_BUTTON ) ||
			( button_types & NO_BUTTON ) )
	{
		sprintf(buf, "GenericCancelB%d", (int)shell_id);
		if ( button_types & CANCEL_BUTTON )
			sprintf(buf, "Cancel");
		else
		if ( button_types & CLOSE_BUTTON )
			sprintf(buf, "Close");
		else
			sprintf(buf, "No");

		button_cancel = gtk_button_new();
		gtk_widget_set_name(button_cancel, "window_button");
		label = gtk_label_new(buf);
		gtk_widget_set_name(label, "window_button");
		gtk_widget_show(label);
		gtk_container_add(GTK_CONTAINER(button_cancel), label);
		gtk_box_pack_start (GTK_BOX (button_form), button_cancel, 
			FALSE, FALSE, 5);
		gtk_widget_show(button_cancel);

		caller_data->cancel = button_cancel;
	}

	if ( button_types & OVERWRITE_BUTTON )
	{
		sprintf(buf, "GenericOverwriteB%d", (int)shell_id);
		sprintf(buf, "Overwrite");
		button_overwrite = gtk_button_new();
		gtk_widget_set_name(button_overwrite, "window_button");
		label = gtk_label_new(buf);
		gtk_widget_set_name(label, "window_button");
		gtk_widget_show(label);
		gtk_container_add(GTK_CONTAINER(button_overwrite), label);
		gtk_box_pack_start (GTK_BOX (button_form), button_overwrite, 
			FALSE, FALSE, 5);

		caller_data->overwrite = button_overwrite;
	}

	if ( button_types & APPEND_BUTTON )
	{
		sprintf(buf, "GenericAppendB%d", (int)shell_id);
		sprintf(buf, "Append");

		button_append = gtk_button_new();
		gtk_widget_set_name(button_append, "window_button");
		label = gtk_label_new(buf);
		gtk_widget_set_name(label, "window_button");
		gtk_widget_show(label);
		gtk_container_add(GTK_CONTAINER(button_append), label);
		gtk_box_pack_start (GTK_BOX (button_form), button_append, 
			FALSE, FALSE, 5);

		caller_data->append = button_append;
	}

	if ( button_types & HELP_BUTTON )
	{
		sprintf(buf, "GenericHelpB%d", (int)shell_id);
		sprintf(buf, "Help");

		button_help = gtk_button_new();
		gtk_widget_set_name(button_help, "window_button");
		label = gtk_label_new(buf);
		gtk_widget_set_name(label, "window_button");
		gtk_widget_show(label);
		gtk_container_add(GTK_CONTAINER(button_help), label);
		gtk_box_pack_start (GTK_BOX (button_form), button_help, 
			FALSE, FALSE, 5);

		caller_data->help = button_help;
	}

	/*
	 * Stuff the callers output structure with the widget ids.
	 */
	caller_data->shell_id = shell_id;
	caller_data->vbox = callers_form;


	DBGExit();

	/* return to the caller */
	return (shell_id);

}

