/* $Id$ */

/*========================================================================
 * Parts of this code Copyright (c) Michael J. Hammel 1995-1999.
 * Original preview code Copyright (c) 1997 Eric L. Hernes (erich@rrnet.com)
 *========================================================================
 *              FILE NAME: mega.c
 *            DESCRIPTION: code for helping manage previews.
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *       PUBLIC FUNCTIONS: GFXCenterWindow
 *      PRIVATE FUNCTIONS: 
 *  SOFTWARE DEPENDENCIES: 
 *  HARDWARE DEPENDENCIES: 
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *
 * Some of this code is borrowed from the megawidget code in the Gimp.
 * I've translated it for use in the GFXMuse Tools.
 * The following disclaimer and copyright are taken from megawidget.c:
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software withough specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/

#define GFX_PREVIEWS_C

/* === System Headers === */
#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/stat.h>

#include <gtk/gtk.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>


/* === Project Headers === */
#include "gfxcommon.h"
#include "debug.h"


/* === external routines === */


/* === Public routine prototypes === */


/* === Private routine prototypes === */


/* === Global Variables === */


/* === Static Variables === */



/*========================================================================
 *	Name:			GFX_mw_preview_build_virgin
 *	Prototype:	void GFX_mw_preview_build_virgin( 
 *							GimpDrawable	*drw,
 *							gint			*preview_width,
 *							gint			*preview_height )
 *
 *	Description:
 *		Initialize a preview region.
 *
 *	Input Arguments:
 *		GimpDrawable 	*drw					the source drawable
 *		gint			preview_width		self explanatory
 *		gint			preview_height		self explanatory
 *
 *	Output Arguments:
 *		struct mwPreview *	A pointer to a structure holding the preview
 *									data
 *	Return Values:
 *	Global Variables:
 *	External Routines:
 *	Method:
 *	Restrictions:
 *	Notes:
 *========================================================================*/
struct mwPreview *
GFX_mw_preview_build_virgin(
	GimpDrawable	*drw,
	gint			preview_width,
	gint			preview_height
)
{
	struct mwPreview *mwp;

	mwp = (struct mwPreview *)malloc(sizeof(struct mwPreview));
	if (drw->width > drw->height) 
	{
		if ( drw->width > preview_width )
		{
			mwp->scale = (gdouble)drw->width / (gdouble)preview_width;
			mwp->width = preview_width;
			mwp->height = (drw->height) / (mwp->scale);
		}
		else
		{
			mwp->scale = 1;
			mwp->width = drw->width;
			mwp->height = drw->height;
		}
	} 
	else 
	{
		if ( drw->height > preview_height )
		{
			mwp->scale = (gdouble)drw->height / (gdouble)preview_height;
			mwp->height = preview_height;
			mwp->width = (drw->width) / (mwp->scale);
		}
		else
		{
			mwp->scale = 1;
			mwp->width = drw->width;
			mwp->height = drw->height;
		}
	}

	mwp->bpp = 3;
	mwp->bits = NULL;
	return(mwp);
}



/*========================================================================
 *	Name:			GFX_mw_preview_build
 *	Prototype:	void GFX_mw_preview_build( 
 *							GimpDrawable	*drw,
 *							gint			*preview_width,
 *							gint			*preview_height )
 *
 *	Description:
 *		Build a preview region.
 *
 *	Input Arguments:
 *		GimpDrawable 	*drw					the source drawable
 *		gint			preview_width		self explanatory
 *		gint			preview_height		self explanatory
 *
 *	Output Arguments:
 *		struct mwPreview *	A pointer to a structure holding the preview
 *									data
 *	Return Values:
 *	Global Variables:
 *	External Routines:
 *	Method:
 *	Restrictions:
 *	Notes:
 *========================================================================*/
struct mwPreview *
GFX_mw_preview_build(
	GimpDrawable	*drw,
	gint			preview_width,
	gint			preview_height
)
{
	struct mwPreview	*mwp;
	gint					x, y, b;
	guchar				*bc, *drwBits;
	GimpPixelRgn			pr;

	mwp = GFX_mw_preview_build_virgin(drw, preview_width, preview_height);

	gimp_pixel_rgn_init(&pr, drw, 0, 0, drw->width, drw->height, FALSE, FALSE);
	drwBits = (guchar *)g_malloc(drw->width * drw->bpp);

	mwp->bpp = 3;
	bc = mwp->bits = (guchar *)malloc(mwp->width*mwp->height*mwp->bpp);

	for(y=0; y<mwp->height; y++) 
	{
		gimp_pixel_rgn_get_row(&pr, drwBits, 0, (int)(y*mwp->scale), drw->width);
		for(x=0; x<mwp->width; x++) 
		{
			for(b=0; b<mwp->bpp; b++)
				*bc++ =* (drwBits + ((gint)(x*mwp->scale) * drw->bpp) + b%drw->bpp);
		}
	}

	g_free(drwBits);
	return(mwp);
}


/*========================================================================
 *	Name:			GFX_mw_preview_new
 *	Prototype:	void GFX_mw_preview_new( 
 *								GtkWidget			*parent, 
 *								struct mwPreview	*mwp, 
 *								char					*title)
 *
 *	Description:
 *		Build a preview region.
 *
 *	Input Arguments:
 *		GimpDrawable 	*drw					the source drawable
 *		gint			preview_width		self explanatory
 *		gint			preview_height		self explanatory
 *
 *	Output Arguments:
 *		struct mwPreview *	A pointer to a structure holding the preview
 *									data
 *	Return Values:
 *	Global Variables:
 *	External Routines:
 *	Method:
 *	Restrictions:
 *	Notes:
 *========================================================================*/
GtkWidget *
GFX_mw_preview_new(
	GtkWidget			*parent, 
	struct mwPreview	*mwp, 
	char					*title
)
{
	GtkWidget *preview;
	GtkWidget *frame;
	GtkWidget *pframe;
	GtkWidget *vbox;
	guchar *color_cube;
   
	gtk_preview_set_gamma (gimp_gamma ());
	gtk_preview_set_install_cmap (gimp_install_cmap ());
	color_cube = gimp_color_cube ();
	gtk_preview_set_color_cube (color_cube[0], color_cube[1],
			color_cube[2], color_cube[3]);

	gtk_widget_set_default_visual (gtk_preview_get_visual ());
	gtk_widget_set_default_colormap (gtk_preview_get_cmap ());

	frame = gtk_frame_new(title);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);
	gtk_box_pack_start(GTK_BOX(parent), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);
	
	vbox = gtk_vbox_new(FALSE, 2);
	gtk_container_border_width(GTK_CONTAINER(vbox), 2);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);
	
	pframe = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(pframe), GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(pframe), 3);
	gtk_box_pack_start(GTK_BOX(vbox), pframe, FALSE, FALSE, 0);
	gtk_widget_show(pframe);
	
	preview = gtk_preview_new(GTK_PREVIEW_COLOR);
	gtk_preview_size(GTK_PREVIEW(preview), mwp->width, mwp->height);
	gtk_container_add(GTK_CONTAINER(pframe), preview);
	gtk_widget_show(preview);
	
	return preview;
}
	
