/* $Id$ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1995,1996,1997,1998.
 *========================================================================
 *              FILE NAME: utils.c
 *            DESCRIPTION: generally useful utility routines
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *       PUBLIC FUNCTIONS: GFXCenterWindow
 *      PRIVATE FUNCTIONS: 
 *  SOFTWARE DEPENDENCIES: 
 *  HARDWARE DEPENDENCIES: 
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/
#define GFX_UTILS_C

/* === System Headers === */
#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/stat.h>

#include <gtk/gtk.h>


/* === Project Headers === */
#include "gfxcommon.h"
#include "debug.h"


/* === external routines === */


/* === Public routine prototypes === */


/* === Private routine prototypes === */


/* === Global Variables === */


/* === Static Variables === */



/*========================================================================
 *	Name:			GFXCenterWindow
 *	Prototype:	void GFXCenterWindow( GtkWidget *widget )
 *
 *	Description:
 *		Centers a window on the display.
 *
 *	Input Arguments:
 *		GtkWidget 	*widget		widget to center on display.
 *
 *	Output Arguments:
 *	Return Values:
 *	Global Variables:
 *	External Routines:
 *	Method:
 *	Restrictions:
 *	Notes:
 *========================================================================*/
void
GFXCenterWindow(
	GtkWidget	*widget
)
{
	gint		widget_width, widget_height;
	gint		xpos, ypos;

	/*
	 * Center the dialog in the display.
	 */
	GTK_WIDGET_GET_USIZE_WIDTH(widget, widget_width);
	GTK_WIDGET_GET_USIZE_HEIGHT(widget, widget_height);

	xpos = (gdk_screen_width()/2) - (widget_width/2);
	ypos = (gdk_screen_height()/2) - (widget_height/2);

 	gtk_widget_set_uposition( widget, xpos, ypos );

}

