/* $Id$ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1995, 1996, 1997, 1998
 *========================================================================
 *              FILE NAME: config.h
 *            DESCRIPTION: compile time configurable options for 
 *								 : GFXMuseTools
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *
 *
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/

/*
 * Where are the libraries and include files?  
 * Uncomment and set these if your GTK libs and include files are installed 
 * in a nonstandard location.  "Standard" would be /usr/local/lib or /usr/lib,
 * for example.
 */
GTK_LIB=`gtk-config --libs`
GTK_INC=`gtk-config --cflags`

/*
 * Where are the libraries and include files?  
 * Uncomment and set these if your GIMP libs and include files are installed 
 * in a nonstandard location.  "Standard" would be /usr/local/lib or /usr/lib,
 * for example.
 */
GIMP_LIB=`gimp-config --libs`
GIMP_INC=`gimp-config --cflags`

/*
 * Uncomment this if you have GTK compiled with the X Input Extension.
 */
#define USE_XINPUT

/*
 * Uncomment the following if you use a system that doesn't know about
 * bzero() - like Solaris, for example.
#define NO_BZERO
 */

/*
 * Uncomment this if you want to turn the debug macros off.  By default
 * the macros expand into real source code.  Note that even if
 * expanded, no debug output will be generated unless you use the appropriate
 * command line options: --debugfile <file> and --debuglevel <level>
#define DEBUGOFF
 */

/*
 * Uncomment this if you use gcc.  If your "cc" is a sym-link to gcc or
 * you've renamed gcc to cc, then uncomment this as well.  You don't
 * have to (I don't think), but it helps.
 */
#define HASGCC

/*
 * Define the tar command use for building a distributable package here.
 * Almost no one (except people like me who use two different versions of
 * tar) will need to change this.
TAR=gtar cvzf 
 */

/*=========================================================================
 * End of configurable options.
 * You don't need to change anything below this line.
 *=========================================================================*/

/*
 * Which Gimp do we want to use?
 */
GIMPVER= -DGIMP12

/*
 * Do we need to hack around the bzero() problem?
 */
#ifdef NO_BZERO
USE_MEMSET = -DSYSV_USE_MEMSET
#endif

/*
 * Put all those defines together.
 */
OTHER_DEFINES = $(USE_MEMSET) $(GIMPVER)


/*
 * Compile and Link options; complex, but thats what we get when we don't
 * compile with the same compiler across platforms.
 * DEGBUG - turns on local debugging library
 * -Wall  - turns on exhaustive checking by gcc compiler
 * -Wno-unused  - turns off notices about unused parameters and variables.
 *		This is useful because the GUI has lots of unused parameters
 *		in callbacks and these are required by only some compilers.
 */

#ifdef DEBUGOFF
#    ifdef HASGCC
CC = gcc
/* DEFINES   = -g -Wall -Wno-unused $(OTHER_DEFINES)
 */
DEFINES   = -g -Wall $(OTHER_DEFINES)
#    else
DEFINES   = $(OTHER_DEFINES)
#    endif
#else
#    ifdef HASGCC
CC = gcc
/* DEFINES   = -g -Wall -Wno-unused -DDEBUG $(OTHER_DEFINES)
 */
DEFINES   = -g -Wall -DDEBUG $(OTHER_DEFINES)
#    else
DEFINES   = -DDEBUG $(OTHER_DEFINES)
#    endif
#endif


/*
 * Prep for non-standard GTK/Gimp installations.
 */
PKGLIBS1 = $(GTK_LIB)
PKGINCS1 = $(GTK_INC)

PKGLIBS2 = $(GIMP_LIB)
PKGINCS2 = $(GIMP_INC)

/*
PKGLIBS = $(PKGLIBS1) $(PKGLIBS2)
PKGINCS = $(PKGINCS1) $(PKGINCS2)
*/
PKGLIBS = $(GIMP_LIB)
PKGINCS = $(GIMP_INC)

/*
 * Add X Input library if necessary.
 */
#ifdef USE_XINPUT
XINPUT = -lXi
#endif
