/* $Id: debug.c,v 1.2 1997/10/01 16:53:09 mjhammel Exp $ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1995.
 *========================================================================
 *              FILE NAME: debug.c
 *            DESCRIPTION: handle the varargs list of the debug macros
 *       PUBLIC FUNCTIONS: ADMDebugOut, DBGStringToInt
 *  SOFTWARE DEPENDENCIES: requires stdarg.h, string handling routines
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 *	The following naming conventions are used throughout the source:
 *
 * Public routines:
 *		prefixed w/ADM, no underscores, mixed case	ADMPublicRoutine
 * Private routines:
 *		no underscores, mixed case							PrivateRoutine
 * Global variables:
 *		prefixed w/ADM, underscores, mixed case		ADM_Global_Variable
 * Static variables:
 *		underscores, lower case								static_variable;
 * Defined values (except debug macros):	
 *		underscores and all caps							DEFINED_VALUE
 * Debug macros
 *		no underscores, mixed caps, prefixed w/DBG	DBGMacro
 *
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log: debug.c,v $
 * Revision 1.2  1997/10/01 16:53:09  mjhammel
 * No CR - just cleaning up the SunOS build a little and fixing a problem
 * where the debug level was not being set properly for SunOS systems.
 *
 * Revision 1.1  1997/07/31 18:23:38  mjhammel
 * Initial AAWIN (GUI) check in.  mjhammel
 *
 *
 *========================================================================*/
#ifndef DEBUG_C
#define DEBUG_C

#ifdef DEBUG

/* === System Headers === */
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>

#ifdef AMASS_SUNOS
#include <varargs.h>
#include "sun_protos.h"
#endif

/*========================================================================
 *	Name:			ADMDebugOut
 *	Prototype:	ADMDebugOut(const char *fmt, ... )
 *
 *	Description:
 *		handles varargs list of debug macros
 *
 *	Restrictions:
 *		this routine should only be called using the debug macros
 *		listed in debug.h
 *
 *	Notes:
 *		
 *========================================================================*/

char *
ADMDebugOut ( const char *fmt, ... )
{
	va_list			ap;
	static char		p[255];

	va_start (ap, fmt);
	(void) vsprintf(p, fmt, ap);
	va_end (ap);
	return (p);
}

/*========================================================================
 *	Name:			DBGStringToInt
 *	Prototype:	DBGStringToInt(char *buf)
 *
 *	Description:
 *		Converts a command line string to its integer value.
 *
 * Returns:
 *		The debug level or -1 if the value is not an integer.
 *
 *	Restrictions:
 *	Notes:
 *		
 *========================================================================*/
int
DBGStringToInt( char *buf )
{
	int	i, level;

	/* The hex input case */
	if ( strncmp(buf, "0x", 2) == 0 )
		for ( i = 2; i < strlen(buf); i++ )
		{
			if ( isdigit ( buf[i] ) == 0 )
				if ( strchr ( "ABCDEF", buf[i] ) == NULL )
					if ( strchr ( "abcdef", buf[i] ) == NULL )
						return(-1);
		}
	else
		/* The decimal input case */
		for ( i = 0; i < strlen(buf); i++ )
		{
			if ( isdigit ( buf[i] ) == 0 )
				return(-1);
		}

	if ( strncmp(buf, "0x", 2) == 0 )
		sscanf (buf, "0x%x", &level);
	else
		sscanf (buf, "%d", &level);
	return (level);

}

#endif /* DEBUG */

#endif /* DEBUG_C */

