/* $Id: debug.h,v 1.2 1997/08/14 21:36:46 mjhammel Exp $ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1995.
 *========================================================================
 *              FILE NAME: debug.h
 *            DESCRIPTION: header file for debug facility
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *                  NOTES: Set tabstops=3 for readability
 *								 : The debug macros make use of a static
 *								 : character string called fname[].  If this
 *								 : is not defined, the debug macros will not
 *								 : compile.
 *
 * SPECIAL CONSIDERATIONS:
 *	The following naming conventions are used throughout the source:
 *
 * Defined values (except debug macros):	
 *		prefixed w/ADM, underscores and all caps		ADM_DEFINED_VALUE
 * Debug macros
 *		no underscores, mixed caps, prefixed w/DBG	DBGMacro
 *
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log: debug.h,v $
 * Revision 1.2  1997/08/14 21:36:46  mjhammel
 * Changes to make debug get compiled in by default, but not be turned on
 * by default.  Now, if you need debug output you only need to specify
 * the debug level and debug file on the command line.  Do "aawin -help"
 * to get more info.
 *
 * Note that the debug stuff in aawin is different than the debug thats in
 * AMASS.  The two are not related in any way - in AAWin the debug output
 * always gets written to a file, be it a regular file or /dev/console.
 *
 * Revision 1.1  1997/07/31 18:23:38  mjhammel
 * Initial AAWIN (GUI) check in.  mjhammel
 *
 *
 *========================================================================*/
#ifndef DEBUG_H
#define DEBUG_H

/* make sure the top level header file is included */
#ifndef _SYS_STAT_H
#include <sys/stat.h>
#endif
#ifndef _SYS_TYPES_H
#include <sys/types.h>
#endif
#ifndef _UNISTD_H
#include <unistd.h>
#endif
#ifndef _FCNTL_H
#include <fcntl.h>
#endif


#define DEBUG_CONSOLE_DEV	"/dev/null"		/* where to write to by default */


#ifdef DEBUG

#define DEBUG_ENTER			"Entered routine\n"
#define DEBUG_EXIT			"Exiting routine\n"

#define DBG_PROC			0x0001					/* procedure specific debug */
#define DBG_INFO			0x0002					/* general info */
#define DBG_PARSE			0x0004					/* parser info */
#define DBG_WINDOWS		0x0008					/* window creation info */
#define DBG_UTIL			0x0010					/* utility routines info */
#define DBG_TRACE1		0x0020					/* Extra tracing info - level 1 */
#define DBG_TRACE2		0x0040					/* Extra tracing info - level 2 */
#define DBG_TRACE3		0x0080					/* Extra tracing info - level 3 */
#define DBG_SPECIAL		0x0100					/* special? */
#define DBG_ALL			0xFFFF					/* All possible debug output */


extern char *ADMDebugOut();		/* found in debug.c */


/* provide some storage for the debug message strings */
#ifdef MAIN_C
int	GMDebugLevel = 0;		/* 0 means no debug output by default */
char	*DBGFile=DEBUG_CONSOLE_DEV;
char	*DBGbuf;
int	DEBUG_FD;					/* filedesc for debug output */

extern int	DBGStringToInt();
#else

extern char	*DBGFile;
extern char	*DBGbuf;
extern int	GMDebugLevel;
extern int	DEBUG_FD;

extern int	DBGStringToInt();
#endif

/* Open the Debug output stream */
#define DBGOpen(fd)																		\
{																								\
	if ( ( fd = open ( DBGFile, 														\
				O_WRONLY | O_CREAT | O_TRUNC, 0666 ) ) == -1 )					\
	{																							\
		fprintf ( stderr, "Can't open %s\n", DBGFile );							\
		exit ( -1 );																		\
	}																							\
}


/* Close the Debug output stream */
#define DBGClose(fd)					\
{											\
	if ( fd != 0 )						\
		close ( fd );					\
}

	
/* Enter a routine */
#define DBGEnter()															\
{																					\
	if (GMDebugLevel & DBG_PROC)											\
	{																				\
		write ( DEBUG_FD, fname, strlen(fname) );						\
		write ( DEBUG_FD, ": ", 2 );										\
		write ( DEBUG_FD, DEBUG_ENTER, strlen (DEBUG_ENTER) );	\
	}																				\
}

/* Exit a routine */
#define DBGExit()																	\
{																						\
	if (GMDebugLevel & DBG_PROC)												\
	{																					\
		char	DBGString[256];													\
		write ( DEBUG_FD, fname, strlen(fname) );							\
		sprintf ( DBGString, " [%s(%d)]", __FILE__, __LINE__ );		\
		write ( DEBUG_FD, DBGString, strlen(DBGString));				\
		write ( DEBUG_FD, ": ", 2 );											\
		write ( DEBUG_FD, DEBUG_EXIT, strlen (DEBUG_EXIT) );			\
	}																					\
}


/*
 * Print just the message provided
 *
 * NOTE:  the newline is not provided!
 */
#define DBGPrint(level,A)														\
{																						\
	if (GMDebugLevel & (level))		 										\
	{																					\
		char	DBGString[256];													\
		write ( DEBUG_FD, fname, strlen(fname) );							\
		sprintf ( DBGString, " [%s(%d)]", __FILE__, __LINE__ );		\
		write ( DEBUG_FD, DBGString, strlen(DBGString));				\
		write ( DEBUG_FD, ": ", 2 );											\
		write ( DEBUG_FD, A, strlen(A) );									\
	}																					\
}


/*
 * format some debug output
 * An example of using this is:
 *		DBGPrintf(DBG_INFO, ("name: %s\n", name));
 *
 * This would expand the sprintf() call below to:
 * sprintf ( DBGbuf, "name: %s\n", name );
 *
 * NOTE:  the caller must specify the newline!
 * NOTE2: this macro relies on the ADMDebugOut()
 * 		 routine found in debug.c!
 */

#define DBGPrintf(level,A)														\
{																						\
	if (GMDebugLevel & (level))												\
	{																					\
		char	DBGString[256];													\
		write ( DEBUG_FD, fname, strlen(fname) );							\
		sprintf ( DBGString, " [%s(%d)]", __FILE__, __LINE__ );		\
		write ( DEBUG_FD, DBGString, strlen(DBGString));				\
		DBGbuf= (char *)ADMDebugOut A ;										\
		write ( DEBUG_FD, ": ", 2 );											\
		write ( DEBUG_FD, DBGbuf, strlen(DBGbuf) );						\
	}																					\
}

/*
 * Format some debug output
 * This is just like DBGPrintf(), except the prefix info is
 * not printed.  This is a handy way of formatting some debug
 * output.  The first line would be a DBGPrintf() (using a newline
 * as the first printed character) following by one or more
 * DBGWrite()'s.
 */

#define DBGWrite(level,A)														\
{																						\
	if (GMDebugLevel & (level))												\
	{																					\
		DBGbuf= (char *)ADMDebugOut A ;										\
		write ( DEBUG_FD, DBGbuf, strlen(DBGbuf) );						\
	}																					\
}

#else

#define DBGOpen(fd)
#define DBGClose(fd)
#define DBGEnter()
#define DBGExit()
#define DBGPrint(level, A)
#define DBGPrintf(level, A)
#define DBGWrite(level, A)

#endif /* DEBUG */


#endif /* DEBUG_H */
