/* $Id$ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1998.
 *========================================================================
 *              FILE NAME: gfxmuse-common.h
 *            DESCRIPTION: common header file for GFXMuse Tools
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *       PUBLIC FUNCTIONS: 
 *      PRIVATE FUNCTIONS: 
 *  SOFTWARE DEPENDENCIES: 
 *  HARDWARE DEPENDENCIES: 
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/
#ifndef GFXCOMMON_H
#define GFXCOMMON_H

#include "gfxgtk.h"

/*
 * Text strings used in various places.
 */
#define GFX_S_ERROR_TITLE		"Error"
#define GFX_S_INFO_TITLE		"Info"
#define GFX_S_MSG_TITLE			"Message"
#define GFX_S_CONFIRM_TITLE	"Confirmation"
#define GFX_S_HELP_DIALOG		"Help"

/*
 * Buttons to use in generic shell widgets.  There are gaps in here, but
 * thats not important right now.
 */
#define ACCEPT_BUTTON		0x0001   /* accepts input and begins processing */
#define CANCEL_BUTTON		0x0002   /* used to close windows */
#define OK_BUTTON				0x0004   /* displays "OK" instead of "Accept" */
#define OVERWRITE_BUTTON	0x0008   /* overwrites a file */
#define APPEND_BUTTON		0x0010   /* appends to a file */
#define HELP_BUTTON			0x0020   /* opens help window */
#define PRINT_BUTTON			0x0040   /* same as "accept", but displays "Print" */
#define YES_BUTTON			0x0080   /* same as "accept", but displays "Yes" */
#define CLOSE_BUTTON			0x0100   /* same as "Cancel" but w/different text */
#define NO_BUTTON				0x0200   /* same as "Cancel" but w/different text */
#define SEARCH_BUTTON		0x0400   /* same as "accept" but w/different text */
#define ALL_BUTTON			0x0fff   /* never used */
 
/*
 * Message Window types
 */
#define GFX_ERROR_TYPE		0x0001
#define GFX_MSG_TYPE			0x0002
#define GFX_INFO_TYPE		0x0004
#define GFX_CONFIRM_TYPE	0x0008
#define GFX_MSG_NOCANCEL	0x0100
#define GFX_MSG_NOHELP		0x0200
#define GFX_MSG_NOOK			0x0400


/*
 * Just in case.
 */
#ifndef MAXPATHLEN
#define MAXPATHLEN			1024
#endif

/*
 * Generic dialog's text widget default dimensions.
 */
#define GFX_DIALOG_WIDTH	200
#define GFX_DIALOG_HEIGHT	200

/*
 * GTK can't run a widgets list of children in 1.0.1.  So generic.c needs
 * a datastructure to pass back widget ids.
 */
typedef struct _gshell_t {
	GtkWidget	*shell_id;
	GtkWidget	*vbox;
	GtkWidget	*accept;
	GtkWidget	*cancel;
	GtkWidget	*overwrite;
	GtkWidget	*append;
	GtkWidget	*help;
} GShell_T;


/*
 * For common-d/mega.c - borrowed from the megawidget plug-in for the Gimp.
 * see common-d/mega.c for copyright information.
 */
struct mwPreview {
	gint width;
	gint height;
	gint bpp;
	gdouble scale;
	guchar *bits;
};

/* These were 1.0 definitions that were changed somewhere in 1.2 */
/*
#define GimpDrawable GimpDrawable
#define GimpPixelRgn GimpPixelRgn
#define GimpPlugInInfo GimpPlugInInfo
#define GimpParamDef GimpParamDef
#define GimpPlugInInfo GimpPlugInInfo

#define GIMP_ENABLE_COMPAT_CRUFT
#include <libgimp/gimpcompat.h>
#undef GIMP_ENABLE_COMPAT_CRUFT
*/

#endif /* GFXCOMMON_H */
