/* $Id$ */

/*========================================================================
 *  Copyright (c) Michael J. Hammel 1998.
 *========================================================================
 *              FILE NAME: lightning.h
 *            DESCRIPTION: main header file for TransGFX plug-in
 *      DEFINED CONSTANTS: 
 *       TYPE DEFINITIONS: 
 *      MACRO DEFINITIONS: 
 *       GLOBAL VARIABLES: 
 *       PUBLIC FUNCTIONS: 
 *      PRIVATE FUNCTIONS: 
 *  SOFTWARE DEPENDENCIES: 
 *  HARDWARE DEPENDENCIES: 
 *                  NOTES: 
 *
 * SPECIAL CONSIDERATIONS:
 * Set your tabstops to 3 to make the code more readable.
 *========================================================================
 *
 * MODIFICATION HISTORY:
 * $Log$
 *
 *========================================================================*/
#ifndef BOLTGFX_H
#define BOLTGFX_H

/*
 * Information used by gimp_install_procedure() in the TransGFXQuery() 
 * routine.
 */
#define BOLTGFX_NAME				"plugin-boltgfx"
#define BOLTGFX_BLURB			"Generate lightning bolts"
#define BOLTGFX_HELP				BOLTGFX_BLURB
#define BOLTGFX_AUTHOR			"Michael J. Hammel <mjhammel@graphics-muse.org>"
#define BOLTGFX_COPYRIGHT		"Private License - Copyright 1999 Michael J. Hammel"
#define BOLTGFX_DATE				"1999/05/04"
#define BOLTGFX_MENU_PATH		"<Image>/Filters/GFXMuse/BoltGFX"
#define BOLTGFX_IMAGE_TYPES	"RGB*,GRAY*,INDEXED*"
#define BOLTGFX_PROC_TYPE		GIMP_PLUGIN

/*
 * The name to use for saving configuration data
 */
#define BOLTGFX_PI_NAME		"BoltGFX"

/*
 * Title and Version information for our dialogs.
 */
#define BOLTGFX_TITLE		"BoltGFX "
#define BOLTGFX_VERSION		"0.1"

/*
 * Size of the preview window.  This one we keep square.
 * The diagonal of the page should fit in preview frames overall
 * height/width.
 */
#define PREVIEW_HSIZE				174
#define PREVIEW_WSIZE				174
#define PREVIEW_PG_HSIZE			120	
#define PREVIEW_PG_WSIZE			120

/*
 * Default opacity for new layers.
 */
#define OPACITY_DEFAULT				100.0

/*
 * Generic types.
 */
#define BOLTGFX_TYPE_NEW_LAYER	1
#define BOLTGFX_TYPE_ANCHOR		2

#define BOLTGFX_DOWN					1
#define BOLTGFX_UP					2

/*
 * Identifiers for text field updates routine.
 */
#define BOLTGFX_ANGLE_TEXT_FIELD	1

/*
 * Help Text for TransGFX.
 */
#define GFX_HELP_TEXT	\
"\n\
\n\
                                                   The Graphics Muse Tools\n\
                                                          \"TransGFX\"\n\
\n\
TransGFX Online Help\n\
\n\
Welcome to TransGFX Online from The Graphics Muse!.  TransGFX takes the\n\
active selection or layer and rotates it the specified number of degrees.\n\
You can choose to rotate the preview by hand or type in a specific angle.\n\
Rotations can be turned into new layers or anchored to the existing layer.\n\
\n\
Table of Contents\n\
\n\
  1. A tour of the TransGFX dialog window\n\
  2. Interactively changing the rotation angle\n\
  3. Dialog Buttons\n\
  4. Resetting the dialog\n\
  5. Performing the rotation and closing the dialog\n\
  6. Undoing the rotation\n\
\n\
\n\
A tour of the TransGFX dialog window\n\
\n\
Using TransGFX is fairly easy.  There are a number of features you can\n\
modify.  Starting with the upper left of the dialog window you will find the\n\
Rotation Angle Preview.  This is an interactive display that you can use to\n\
adjust the angle to rotate the active selection or layer.  We'll talk more\n\
about this in a moment.\n\
\n\
To the right of the Preview is a framed box titled Disposition of Rotation.\n\
In this box are two toggle buttons, one labeled New Layer and one labelde\n\
Anchor To Original.  Right before a rotation is performed a floating\n\
selection is created.  These toggles determine the disposition of that\n\
floating layer after the rotation has completed.\n\
\n\
Below these toggles is a button labeled Smooth Jagged Edges.  If selected\n\
this will cause the rotated floating selection to have its edges smoothed\n\
(also known as anti-aliased).  The effect of this smoothing is not obvious\n\
in all rotations so you may need to experiment with it to find out if its\n\
needed or not.\n\
\n\
Following the Smooth button are two options:  a blend mode menu and an\n\
opacity slider with text input field.  The menu, slider and text field are\n\
only applicable if the New Layer toggle is currently set.  If the Anchor to\n\
Original toggle is set then these features become unselectable.  If a new\n\
layer is chosen then its initial blend mode and opacity level are set\n\
according to the option menu and slider setting, respectively.\n\
\n\
Underneath the Preview is a text input field with two arrow buttons.  The\n\
text input field shows the current rotation angle, from -359 to +359\n\
degrees.  When you rotate the box in the preview window this field is\n\
automatically updated.  Alternatively, you can type the angle directly into\n\
this field.  The arrow buttons allow adjustments of 1/1000 of a degree.\n\
\n\
Finally, the layer to use as the source for your rotation can be selected\n\
from the Layer menu below the arrow buttons.\n\
\n\
\n\
Interactively changing the rotation angle\n\
\n\
The Preview window can be modified by clicking inside the frame and dragging\n\
the mouse in any direction.  As you drag the white box will rotate within\n\
the black circular outline, with the dotted line always pointing to where\n\
the current selection's/layer's upper right corner will be after the\n\
rotation.\n\
\n\
When the left moues button is clicked and held, mouse drag operations cause\n\
large changes in the angle of rotation.  You can modify this by using the\n\
Shift and CTRL keys.  Holding the Shift key down while you drag will\n\
decrease the angle rotation by 1/3rd, the CTRL key will decrease it by 1/6th\n\
and holding both down will decrease it by 1/10th.  This should provide\n\
fairly reasonable levels of granularity in the rotation, with even finer\n\
levels achieved by using the arrow buttons.\n\
\n\
\n\
Dialog Buttons\n\
\n\
Along the bottom of the dialog are 5 buttons: OK, Cancel, Reset, Show\n\
Status, and Help.  The Help button opens the Help dialog and displays this\n\
text.  The Show Status button will open a window similar to the Help window\n\
that shows the current status of the TransGFX plug-in as it performs its\n\
rotation of a layer or selection.  Both the Help and Show Status windows can\n\
be closed by clicking on the same dialog button again or by clicking on\n\
those dialogs Close buttons.\n\
\n\
\n\
Resetting the dialog\n\
\n\
All fields and original settings of the dialog can be reset with the Reset\n\
button.  Clicking on this button also will refresh the Layer menu to show\n\
all the layers in the current image (the image from which the TransGFX\n\
dialog was opened).  This is useful for doing rotations of layers that have\n\
just been created by TransGFX.\n\
\n\
\n\
Performing the rotation and closing the dialog\n\
\n\
To perform a rotation simply click on the OK button.  You need not make any\n\
changes to any other part of the dialog before doing so.  In this case, you\n\
will simply get a new layer that contains either the current selection or a\n\
copy of the active layer.\n\
\n\
The TransGFX dialog does not close automatically.  It will remain open so\n\
you can peform multiple rotations if you desire.  To close the dialog,\n\
simply click on the Cancel button.\n\
\n\
\n\
Undoing the rotation\n\
\n\
TransGFX will add either 3 or 4 operations to the Undo stack.  To get back\n\
to where you where prior to the rotation you can type CTRL-Z three times (if\n\
a selection was already present previously) or 4 times (if no selection was\n\
present).\n\
\n\
\n\
"
#endif /* BOLTGFX_H */

