#############################################################
#
# tinyxml
#
#############################################################
TINYXML_VERSION = 2_6_2
TINYXML_SOURCE = tinyxml_2_6_2.zip
TINYXML_SITE = http://$(BR2_SOURCEFORGE_MIRROR).dl.sourceforge.net/project/tinyxml/tinyxml/2.6.2/
TINYXML_INSTALL_STAGING = YES
TINYXML_INSTALL_TARGET = YES

define TINYXML_EXTRACT_CMDS
	unzip -d $(BUILD_DIR)/tinyxml-$(TINYXML_VERSION) $(DL_DIR)/$(TINYXML_SOURCE)
endef

define TINYXML_BUILD_CMDS
	cd $(@D)/tinyxml; sed -i -e '/^TINYXML_USE_STL/ s|=.*|=YES|' -e "s|^RELEASE_CFLAGS.*|& $(CXXFLAGS) -fPIC|" Makefile
	cd $(@D)/tinyxml; for i in tinyxml.cpp tinystr.cpp tinyxmlerror.cpp tinyxmlparser.cpp; do \
		$(TARGET_CXX) $(TARGET_CXXFLAGS) -fPIC -o $$i.o -c $$i; \
	done
	cd $(@D)/tinyxml; $(TARGET_CXX) $(TARGET_CXXFLAGS) -shared -o libtinyxml.so.$(TINYXML_VERSION) -Wl,-soname,libtinyxml.so.0 *.cpp.o
	cd $(@D)/tinyxml; ln -sf libtinyxml.so.$(TINYXML_VERSION) libtinyxml.so.0
	cd $(@D)/tinyxml; ln -sf libtinyxml.so.0 libtinyxml.so
endef

define TINYXML_INSTALL_STAGING_CMDS
	install -d -m 755 $(STAGING_DIR)/usr/lib
	install -d -m 755 $(STAGING_DIR)/usr/include
	install -m 755 $(@D)/tinyxml/libtinyxml.so.2_6_2 $(STAGING_DIR)/usr/lib/libtinyxml.so.2.6.2
	install -m 755 $(@D)/tinyxml/libtinyxml.so.0 $(STAGING_DIR)/usr/lib/libtinyxml.so.0
	install -m 755 $(@D)/tinyxml/libtinyxml.so $(STAGING_DIR)/usr/lib/libtinyxml.so
	install -m 0644 $(@D)/tinyxml/tinyxml.h $(STAGING_DIR)/usr/include/
	install -m 0644 $(@D)/tinyxml/tinystr.h $(STAGING_DIR)/usr/include/
endef

define TINYXML_INSTALL_TARGET_CMDS
	install -d -m 755 $(TARGET_DIR)/usr/lib
	install -d -m 755 $(TARGET_DIR)/usr/include
	install -m 755 $(@D)/tinyxml/libtinyxml.so.2_6_2 $(TARGET_DIR)/usr/lib/libtinyxml.so.2.6.2
	install -m 755 $(@D)/tinyxml/libtinyxml.so.0 $(TARGET_DIR)/usr/lib/libtinyxml.so.0
	install -m 755 $(@D)/tinyxml/libtinyxml.so $(TARGET_DIR)/usr/lib/libtinyxml.so
endef

$(eval $(call GENTARGETS))
