#!/bin/sh

# Only argument is path to target directory
TARGET=$1

# Remove sshd init script, if it exists.
# We use dropbear instead, but OpenSSH adds init script.
if [ -f $TARGET/etc/init.d/S50sshd ]
then
	rm $TARGET/etc/init.d/S50sshd
fi

# Add missing /proc and /sys directories
mkdir -p $TARGET/proc
mkdir -p $TARGET/sys

# Add missing /media directory
mkdir -p $TARGET/media

# Remove dhcpd-server init script. S40network handles that instead.
rm -f $TARGET/etc/init.d/S80dhcp-server
